/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y4A\u0001D\u0007\u00015!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00043\u0001\t\u0007I\u0011B\u001a\t\r}\u0002\u0001\u0015!\u00035\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015a\b\u0001\"\u0001~\u0005U9En\u001c2bYR+W\u000e\u001d,jK^l\u0015M\\1hKJT!AD\b\u0002\u000f\r\fG/\u00197pO*\u0011\u0001#E\u0001\tG\u0006$\u0018\r\\=ti*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\u0011\fG/\u00192bg\u0016\u0004\"a\t\u0016\u000f\u0005\u0011B\u0003CA\u0013\u001e\u001b\u00051#BA\u0014\u001a\u0003\u0019a$o\\8u}%\u0011\u0011&H\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*;\u00051A(\u001b8jiz\"\"aL\u0019\u0011\u0005A\u0002Q\"A\u0007\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\u001fYLWm\u001e#fM&t\u0017\u000e^5p]N,\u0012\u0001\u000e\t\u0005ki\u0012C(D\u00017\u0015\t9\u0004(A\u0004nkR\f'\r\\3\u000b\u0005ej\u0012AC2pY2,7\r^5p]&\u00111H\u000e\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0001T(\u0003\u0002?\u001b\t)B+Z7q_J\f'/\u001f,jK^\u0014V\r\\1uS>t\u0017\u0001\u0005<jK^$UMZ5oSRLwN\\:!Q\u0011!\u0011i\u0013'\u0011\u0005\tKU\"A\"\u000b\u0005\u0011+\u0015AC2p]\u000e,(O]3oi*\u0011aiR\u0001\u000bC:tw\u000e^1uS>t'\"\u0001%\u0002\u000b)\fg/\u0019=\n\u0005)\u001b%!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005i\u0015\u0001\u0002;iSN\f1aZ3u)\t\u00016\u000bE\u0002\u001d#rJ!AU\u000f\u0003\r=\u0003H/[8o\u0011\u0015!V\u00011\u0001#\u0003\u0011q\u0017-\\3\u0002\r\r\u0014X-\u0019;f)\u00119&lW/\u0011\u0005qA\u0016BA-\u001e\u0005\u0011)f.\u001b;\t\u000bQ3\u0001\u0019\u0001\u0012\t\u000bq3\u0001\u0019\u0001\u001f\u0002\u001dYLWm\u001e#fM&t\u0017\u000e^5p]\")aL\u0002a\u0001?\u0006\u0001rN^3se&$W-\u00134Fq&\u001cHo\u001d\t\u00039\u0001L!!Y\u000f\u0003\u000f\t{w\u000e\\3b]\u00061Q\u000f\u001d3bi\u0016$2a\u00183f\u0011\u0015!v\u00011\u0001#\u0011\u0015av\u00011\u0001=\u0003\u0019\u0011X-\\8wKR\u0011q\f\u001b\u0005\u0006)\"\u0001\rAI\u0001\u0007e\u0016t\u0017-\\3\u0015\u0007}[W\u000eC\u0003m\u0013\u0001\u0007!%A\u0004pY\u0012t\u0015-\\3\t\u000b9L\u0001\u0019\u0001\u0012\u0002\u000f9,wOT1nK\u0006iA.[:u-&,wOT1nKN$\"!\u001d>\u0011\u0007I<(E\u0004\u0002tk:\u0011Q\u0005^\u0005\u0002=%\u0011a/H\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018PA\u0002TKFT!A^\u000f\t\u000bmT\u0001\u0019\u0001\u0012\u0002\u000fA\fG\u000f^3s]\u0006)1\r\\3beR\tq\u000b")
public class GlobalTempViewManager {
    @GuardedBy(value="this")
    private final HashMap<String, TemporaryViewRelation> viewDefinitions = new HashMap();

    private HashMap<String, TemporaryViewRelation> viewDefinitions() {
        return this.viewDefinitions;
    }

    public synchronized Option<TemporaryViewRelation> get(String name) {
        return this.viewDefinitions().get((Object)name);
    }

    public void create(String name, TemporaryViewRelation viewDefinition, boolean overrideIfExists) {
        GlobalTempViewManager globalTempViewManager = this;
        synchronized (globalTempViewManager) {
            if (!overrideIfExists && this.viewDefinitions().contains((Object)name)) {
                throw new TempTableAlreadyExistsException(name);
            }
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
        }
    }

    public synchronized boolean update(String name, TemporaryViewRelation viewDefinition) {
        if (this.viewDefinitions().contains((Object)name)) {
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        return this.viewDefinitions().remove((Object)name).isDefined();
    }

    public synchronized boolean rename(String oldName, String newName) {
        if (this.viewDefinitions().contains((Object)oldName)) {
            if (this.viewDefinitions().contains((Object)newName)) {
                throw QueryCompilationErrors$.MODULE$.renameTempViewToExistingViewError(newName);
            }
            TemporaryViewRelation viewDefinition = (TemporaryViewRelation)this.viewDefinitions().apply((Object)oldName);
            this.viewDefinitions().remove((Object)oldName);
            this.viewDefinitions().put((Object)newName, (Object)viewDefinition);
            return true;
        }
        return false;
    }

    public synchronized Seq<String> listViewNames(String pattern) {
        return StringUtils$.MODULE$.filterPattern((Seq<String>)this.viewDefinitions().keys().toSeq(), pattern);
    }

    public synchronized void clear() {
        this.viewDefinitions().clear();
    }

    public GlobalTempViewManager(String database) {
    }
}

