/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=c\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015)\b\u0001\"\u0011Z\u0011!1\b\u0001#b\u0001\n\u00139\b\"\u0002@\u0001\t\u0003z\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\t\t\u0005\u0001C)\u0003\u0007B\u0011\"!\u0014\u0001\u0005\u0004%)%a\u0014\t\u0011\u0005u\u0004\u0001)A\u0007\u0003#B\u0011\"a \u0001\u0003\u0003%\t!!!\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAP\u0001E\u0005I\u0011AAE\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0001\u00026\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0004\u0011\u0011!C!\u0003\u000fD\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005m\u0007!!A\u0005B\u0005u\u0007\"CAq\u0001\u0005\u0005I\u0011IAr\u000f%\u00119\u0001JA\u0001\u0012\u0003\u0011IA\u0002\u0005$I\u0005\u0005\t\u0012\u0001B\u0006\u0011\u0019\u0019V\u0004\"\u0001\u0003$!I!QE\u000f\u0002\u0002\u0013\u0015#q\u0005\u0005\n\u0005Si\u0012\u0011!CA\u0005WA\u0011B!\r\u001e\u0003\u0003%\tIa\r\t\u0013\t\u0015S$!A\u0005\n\t\u001d#!D'ba\u001a\u0013x.\\!se\u0006L8O\u0003\u0002&M\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9\u0003&\u0001\u0005dCR\fG._:u\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\u0002\u0001'\u0015\u0001!GN\u001d@!\t\u0019D'D\u0001%\u0013\t)DE\u0001\tCS:\f'/_#yaJ,7o]5p]B\u00111gN\u0005\u0003q\u0011\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011%\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#1\u0003\u0019a$o\\8u}%\tA(\u0003\u0002Hw\u00059\u0001/Y2lC\u001e,\u0017BA%K\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t95(\u0001\u0003mK\u001a$X#A'\u0011\u0005Mr\u0015BA(%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r)fk\u0016\t\u0003g\u0001AQaS\u0003A\u00025CQ!U\u0003A\u00025\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001[!\tQ4,\u0003\u0002]w\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\tq\fE\u0002AA\nL!!\u0019&\u0003\u0007M+\u0017\u000f\u0005\u0002dM6\tAM\u0003\u0002fQ\u0005)A/\u001f9fg&\u0011q\r\u001a\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u001a\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003_2\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\tI\u0006$\u0018\rV=qKV\t!\u000f\u0005\u0002dg&\u0011A\u000f\u001a\u0002\b\u001b\u0006\u0004H+\u001f9f\u0003!\u0019H/\u0019;fMVd\u0017AC7ba\n+\u0018\u000e\u001c3feV\t\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002|M\u0005!Q\u000f^5m\u0013\ti(P\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003\u0003\t9!a\u0003\u0011\u0007i\n\u0019!C\u0002\u0002\u0006m\u00121!\u00118z\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0003\t\u0001b[3z\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u001ba\u0001\u0019AA\u0001\u0003)1\u0018\r\\;f\u0003J\u0014\u0018-_\u0001\nI><UM\\\"pI\u0016$b!a\u0005\u0002 \u0005%\u0002\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eA%A\u0004d_\u0012,w-\u001a8\n\t\u0005u\u0011q\u0003\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011E\u0007A\u0002\u0005\r\u0012aA2uqB!\u0011QCA\u0013\u0013\u0011\t9#a\u0006\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111F\u0007A\u0002\u0005M\u0011AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003c\u0001B!a\r\u0002<9!\u0011QGA\u001c!\t\u00115(C\u0002\u0002:m\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001dw\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006+\u0006\u0015\u0013\u0011\n\u0005\u0007\u0003\u000fz\u0001\u0019A'\u0002\u000f9,w\u000fT3gi\"1\u00111J\bA\u00025\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003#\u0002B\u0001\u00111\u0002TA!\u0011QKA<\u001d\u0011\t9&!\u001d\u000f\t\u0005e\u0013Q\u000e\b\u0005\u00037\nYG\u0004\u0003\u0002^\u0005%d\u0002BA0\u0003OrA!!\u0019\u0002f9\u0019!)a\u0019\n\u0003=J!!\f\u0018\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&C\u0002\u0002p\u0019\nQ\u0001\u001e:fKNLA!a\u001d\u0002v\u0005YAK]3f!\u0006$H/\u001a:o\u0015\r\tyGJ\u0005\u0005\u0003s\nYHA\u0006Ue\u0016,\u0007+\u0019;uKJt'\u0002BA:\u0003k\nQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013\u0001B2paf$R!VAB\u0003\u000bCqa\u0013\n\u0011\u0002\u0003\u0007Q\nC\u0004R%A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0012\u0016\u0004\u001b\u000655FAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e5(\u0001\u0006b]:|G/\u0019;j_:LA!!(\u0002\u0014\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!*\u0011\t\u0005\u001d\u0016\u0011W\u0007\u0003\u0003SSA!a+\u0002.\u0006!A.\u00198h\u0015\t\ty+\u0001\u0003kCZ\f\u0017\u0002BA\u001f\u0003S\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a.\u0011\u0007i\nI,C\u0002\u0002<n\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0001\u0002B\"I\u00111Y\f\u0002\u0002\u0003\u0007\u0011qW\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0007CBAf\u0003#\f\t!\u0004\u0002\u0002N*\u0019\u0011qZ\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00065'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AWAm\u0011%\t\u0019-GA\u0001\u0002\u0004\t\t!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAS\u0003?D\u0011\"a1\u001b\u0003\u0003\u0005\r!a.\u0002\r\u0015\fX/\u00197t)\rQ\u0016Q\u001d\u0005\n\u0003\u0007\\\u0012\u0011!a\u0001\u0003\u0003A3\u0003AAu\u0003_\f\t0!>\u0002x\u0006m\u0018Q B\u0001\u0005\u0007\u00012aMAv\u0013\r\ti\u000f\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u00190AA\u0003\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK6fsNd\u0003E^1mk\u0016\u001c\u0018\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!o&$\b\u000eI1!a\u0006L'\u000fI8gAQDW\rI4jm\u0016t\u0007e[3z_Y\fG.^3!CJ\u0014\u0018-_:/A\u0005cG\u000eI3mK6,g\u000e^:\u000bA\u0001\u0002\u0003\u0005\t\u0011j]\u0002ZW-_:!g\"|W\u000f\u001c3!]>$\bEY3!]VdG.\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI0A2\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c9\u0002D\u0006I\u001a/a%b\u0003%\u0019:sCfDsEM\u0014-A\u001d\"t%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\fd\u0006\r\u001e#e\tb3G\f\u0019;EQ\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ty0A\u00033]Qr\u0003'A\u0003he>,\b/\t\u0002\u0003\u0006\u0005IQ.\u00199`MVt7m]\u0001\u000e\u001b\u0006\u0004hI]8n\u0003J\u0014\u0018-_:\u0011\u0005Mj2#B\u000f\u0003\u000e\te\u0001c\u0002B\b\u0005+iU*V\u0007\u0003\u0005#Q1Aa\u0005<\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0006\u0003\u0012\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002.\u0006\u0011\u0011n\\\u0005\u0004\u0013\nuAC\u0001B\u0005\u0003!!xn\u0015;sS:<GCAAS\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)&Q\u0006B\u0018\u0011\u0015Y\u0005\u00051\u0001N\u0011\u0015\t\u0006\u00051\u0001N\u0003\u001d)h.\u00199qYf$BA!\u000e\u0003BA)!Ha\u000e\u0003<%\u0019!\u0011H\u001e\u0003\r=\u0003H/[8o!\u0015Q$QH'N\u0013\r\u0011yd\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\r\u0013%!AA\u0002U\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0005\u0005\u0003\u0002(\n-\u0013\u0002\u0002B'\u0003S\u0013aa\u00142kK\u000e$\b")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression left;
    private final Expression right;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays x$0) {
        return MapFromArrays$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        DataType keyType = ((ArrayType)this.left().dataType()).elementType();
        return TypeUtils$.MODULE$.checkForMapKeyType(keyType);
    }

    public MapType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    @Override
    public boolean stateful() {
        return true;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        MapFromArrays mapFromArrays = this;
        synchronized (mapFromArrays) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if (!this.bitmap$0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        return this.mapBuilder().from(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(keyArrayData, valueArrayData) -> {
            String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
            return ev.value() + " = " + builderTerm + ".from(" + keyArrayData + ".copy(), " + valueArrayData + ".copy());";
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    @Override
    public MapFromArrays withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.MAP_FROM_ARRAYS(), (List)Nil$.MODULE$);
    }
}

