/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first matching element of\n      the array as long, or 0 if no match is found.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(312, 773, 708, 708), 708);\n       3\n      > SELECT _FUNC_(array(312, 773, 708, 708), 414);\n       0\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011!\u0001\u0007\u0001#b\u0001\n\u0013\t\u0007\"\u00027\u0001\t\u0003j\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002?\u0001\t\u0003j\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!a\u0012\u0001\t#\nI\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u00111\f\u0001\u0012\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003g\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAI\u0001\u0005\u0005I\u0011AAJ\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0017\u0005\n\u0003k\u0003\u0011\u0011!C!\u0003o;\u0011\"a7\"\u0003\u0003E\t!!8\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003?DaA\u0016\u000e\u0005\u0002\u0005]\b\"CA}5\u0005\u0005IQIA~\u0011%\tiPGA\u0001\n\u0003\u000by\u0010C\u0005\u0003\u0006i\t\t\u0011\"!\u0003\b!I!\u0011\u0004\u000e\u0002\u0002\u0013%!1\u0004\u0002\u000e\u0003J\u0014\u0018-\u001f)pg&$\u0018n\u001c8\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00184mq\u0012\u0005C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011qGO\u0007\u0002q)\u0011\u0011(J\u0001\u0007KJ\u0014xN]:\n\u0005mB$aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!aR\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014B\u0001&?\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)s\u0014\u0001\u00027fMR,\u0012\u0001\u0015\t\u0003aEK!AU\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aK&\f\u0005\u00021\u0001!)a*\u0002a\u0001!\")A+\u0002a\u0001!\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A/\u0011\u0005ur\u0016BA0?\u0005\u001d\u0011un\u001c7fC:\f\u0001b\u001c:eKJLgnZ\u000b\u0002EB\u00191iY3\n\u0005\u0011l%\u0001C(sI\u0016\u0014\u0018N\\4\u0011\u0005u2\u0017BA4?\u0005\r\te.\u001f\u0015\u0003\u000f%\u0004\"!\u00106\n\u0005-t$!\u0003;sC:\u001c\u0018.\u001a8u\u0003!!\u0017\r^1UsB,W#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E,\u0013!\u0002;za\u0016\u001c\u0018BA:q\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\ta\u000fE\u0002DofL!\u0001_'\u0003\u0007M+\u0017\u000f\u0005\u0002pu&\u00111\u0010\u001d\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aI\u0001\tC:\fG._:jg&!\u0011qAA\u0001\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG#B3\u0002\u000e\u0005E\u0001BBA\b\u0017\u0001\u0007Q-A\u0002beJDa!a\u0005\f\u0001\u0004)\u0017!\u0002<bYV,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005}\u0001CA#?\u0013\r\t\tCP\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005b(A\u0005e_\u001e+gnQ8eKR1\u0011QFA\u001d\u0003\u0007\u0002B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g\t\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003o\t\tD\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tY$\u0004a\u0001\u0003{\t1a\u0019;y!\u0011\ty#a\u0010\n\t\u0005\u0005\u0013\u0011\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t)%\u0004a\u0001\u0003[\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002-\u0002L\u0005=\u0003BBA'\u001d\u0001\u0007\u0001+A\u0004oK^dUM\u001a;\t\r\u0005Ec\u00021\u0001Q\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R\u0001WA,\u00033BqAT\b\u0011\u0002\u0003\u0007\u0001\u000bC\u0004U\u001fA\u0005\t\u0019\u0001)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\f\u0016\u0004!\u0006\u00054FAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055d(\u0001\u0006b]:|G/\u0019;j_:LA!!\u001d\u0002h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006!A.\u00198h\u0015\t\t\u0019)\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u0003{\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a#\u0011\u0007u\ni)C\u0002\u0002\u0010z\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!ZAK\u0011%\t9\nFA\u0001\u0002\u0004\tY)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003;\u0003R!a(\u0002&\u0016l!!!)\u000b\u0007\u0005\rf(\u0001\u0006d_2dWm\u0019;j_:LA!a*\u0002\"\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri\u0016Q\u0016\u0005\t\u0003/3\u0012\u0011!a\u0001K\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI(a-\t\u0013\u0005]u#!AA\u0002\u0005-\u0015AB3rk\u0006d7\u000fF\u0002^\u0003sC\u0001\"a&\u0019\u0003\u0003\u0005\r!\u001a\u0015\u0014\u0001\u0005u\u00161YAc\u0003\u0013\fY-a4\u0002R\u0006U\u0017q\u001b\t\u0004a\u0005}\u0016bAAaC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAd\u0003\u0005\r\"\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A\u0015dW-\\3oi&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003&M\u0017cCN,G-\u000b\u0011j]\u0012,\u0007\u0010I8gAQDW\r\t4jeN$\b%\\1uG\"Lgn\u001a\u0011fY\u0016lWM\u001c;!_\u001aT\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011beJ\f\u0017\u0010I1tA1|gn\u001a\u0017!_J\u0004\u0003\u0007I5gA9|\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtGM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002N\u0006\t\u0019C\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001a2e1\u0002sgN\u001a-A]\u0002\u0004\b\f\u00118aaJC\u0006I\u001c1q%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00154cIb\u0003eN\u001c4Y\u0001:\u0004\u0007\u000f\u0017!oAB\u0014\u0006\f\u00115cQJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\nQa\u001a:pkB\f#!a5\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u00033\fQA\r\u00185]A\nQ\"\u0011:sCf\u0004vn]5uS>t\u0007C\u0001\u0019\u001b'\u0015Q\u0012\u0011]Aw!\u001d\t\u0019/!;Q!bk!!!:\u000b\u0007\u0005\u001dh(A\u0004sk:$\u0018.\\3\n\t\u0005-\u0018Q\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAx\u0003kl!!!=\u000b\t\u0005M\u0018\u0011Q\u0001\u0003S>L1\u0001TAy)\t\ti.\u0001\u0005u_N#(/\u001b8h)\t\tI(A\u0003baBd\u0017\u0010F\u0003Y\u0005\u0003\u0011\u0019\u0001C\u0003O;\u0001\u0007\u0001\u000bC\u0003U;\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%!Q\u0003\t\u0006{\t-!qB\u0005\u0004\u0005\u001bq$AB(qi&|g\u000eE\u0003>\u0005#\u0001\u0006+C\u0002\u0003\u0014y\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\f=\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u001eA!\u00111\u0010B\u0010\u0013\u0011\u0011\t#! \u0003\r=\u0013'.Z2u\u0001")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
QueryErrorsBase,
Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition x$0) {
        return ArrayPosition$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if (!this.bitmap$trans$0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType t;
        DataType dataType;
        DataType dataType2;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null && NullType$.MODULE$.equals(dataType2 = (DataType)tuple2._1()) ? true : tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._2())) {
            return new TypeCheckResult.DataTypeMismatch("NULL_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName()))}))));
        }
        if (tuple2 != null && !ArrayType$.MODULE$.acceptsType(t = (DataType)tuple2._1())) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
        }
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType3 = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType3 instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType3).elementType(), e2)) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(e2, this.prettyName());
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$8(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |int " + pos + " = 0;\n         |for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n         |  if (!" + arr + ".isNullAt(" + i + ") && " + ctx.genEqual(this.right().dataType(), (String)value, getValue) + ") {\n         |    " + pos + " = " + i + " + 1;\n         |    break;\n         |  }\n         |}\n         |" + ev.value() + " = (long) " + pos + ";\n       "));
        });
    }

    @Override
    public ArrayPosition withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

