/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.TableOutputResolver$;
import org.apache.spark.sql.catalyst.analysis.TableOutputResolver$DefaultValueFillMode$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AssignmentUtils$
implements SQLConfHelper,
CastSupport {
    public static final AssignmentUtils$ MODULE$ = new AssignmentUtils$();

    static {
        SQLConfHelper.$init$(MODULE$);
        CastSupport.$init$(MODULE$);
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Seq<Assignment> alignUpdateAssignments(Seq<Attribute> attrs2, Seq<Assignment> assignments, boolean fromStar, boolean coerceNestedTypes) {
        ArrayBuffer errors = new ArrayBuffer();
        Seq output = (Seq)attrs2.map((Function1 & Serializable)attr -> MODULE$.applyAssignments(MODULE$.restoreActualType((Attribute)attr), (Expression)attr, assignments, (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
            errors.$plus$eq((Object)err);
            return BoxedUnit.UNIT;
        }, (Seq<String>)new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$), coerceNestedTypes, fromStar));
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidRowLevelOperationAssignments(assignments, (Seq<String>)errors.toSeq());
        }
        return (Seq)((IterableOps)attrs2.zip((IterableOnce)output)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return new Assignment(attr, expr);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<Assignment> alignInsertAssignments(Seq<Attribute> attrs2, Seq<Assignment> assignments, boolean coerceNestedTypes) {
        ArrayBuffer errors = new ArrayBuffer();
        Tuple2 tuple2 = assignments.partition((Function1 & Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$alignInsertAssignments$1(assignment)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq topLevelAssignments = (Seq)tuple2._1();
        Seq nestedAssignments = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelAssignments, (Object)nestedAssignments);
        Seq topLevelAssignments2 = (Seq)tuple22._1();
        Seq nestedAssignments2 = (Seq)tuple22._2();
        if (nestedAssignments2.nonEmpty()) {
            String nestedAssignmentsStr = ((IterableOnceOps)nestedAssignments2.map((Function1 & Serializable)x$2 -> x$2.sql())).mkString(", ");
            v0 = errors.$plus$eq((Object)("INSERT assignment keys cannot be nested fields: " + nestedAssignmentsStr));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Seq alignedAssignments = (Seq)attrs2.map((Function1 & Serializable)attr -> {
            Expression expression;
            Seq matchingAssignments = (Seq)topLevelAssignments2.collect((PartialFunction)new Serializable((Attribute)attr){
                private static final long serialVersionUID = 0L;
                private final Attribute attr$1;

                public final <A1 extends Assignment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.key().semanticEquals(this.attr$1)) {
                        return (B1)A1;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Assignment x1) {
                    Assignment assignment = x1;
                    return assignment.key().semanticEquals(this.attr$1);
                }
                {
                    this.attr$1 = attr$1;
                }
            });
            if (matchingAssignments.isEmpty()) {
                Option<NamedExpression> defaultExpr = ResolveDefaultColumns$.MODULE$.getDefaultValueExprOrNullLit((Attribute)attr, MODULE$.conf().useNullsForMissingDefaultColumnValues());
                Object object = defaultExpr.isEmpty() ? errors.$plus$eq((Object)("No assignment for '" + attr.name() + "'")) : BoxedUnit.UNIT;
                expression = (Expression)defaultExpr.getOrElse((Function0 & Serializable)() -> attr);
            } else if (matchingAssignments.length() > 1) {
                String conflictingValuesStr = ((IterableOnceOps)matchingAssignments.map((Function1 & Serializable)x$3 -> x$3.value().sql())).mkString(", ");
                errors.$plus$eq((Object)("Multiple assignments for '" + attr.name() + "': " + conflictingValuesStr));
                expression = attr;
            } else {
                .colon.colon colPath = new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$);
                Attribute actualAttr = MODULE$.restoreActualType((Attribute)attr);
                Expression value = ((Assignment)matchingAssignments.head()).value();
                Enumeration.Value coerceMode = coerceNestedTypes ? TableOutputResolver$DefaultValueFillMode$.MODULE$.RECURSE() : TableOutputResolver$DefaultValueFillMode$.MODULE$.NONE();
                expression = TableOutputResolver$.MODULE$.resolveUpdate("", value, actualAttr, MODULE$.conf(), (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
                    errors.$plus$eq((Object)err);
                    return BoxedUnit.UNIT;
                }, (Seq<String>)colPath, coerceMode);
            }
            Expression resolvedValue = expression;
            return new Assignment((Expression)attr, resolvedValue);
        });
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidRowLevelOperationAssignments(assignments, (Seq<String>)errors.toSeq());
        }
        return alignedAssignments;
    }

    public boolean alignInsertAssignments$default$3() {
        return false;
    }

    private Attribute restoreActualType(Attribute attr) {
        return attr.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable)() -> attr.dataType()));
    }

    private Expression applyAssignments(Attribute col, Expression colExpr, Seq<Assignment> assignments, Function1<String, BoxedUnit> addError, Seq<String> colPath, boolean coerceNestedTypes, boolean updateStar) {
        Tuple2 tuple2 = assignments.partition((Function1 & Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$applyAssignments$1(colExpr, assignment)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq exactAssignments = (Seq)tuple2._1();
        Seq otherAssignments = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exactAssignments, (Object)otherAssignments);
        Seq exactAssignments2 = (Seq)tuple22._1();
        Seq otherAssignments2 = (Seq)tuple22._2();
        Seq fieldAssignments = (Seq)otherAssignments2.filter((Function1 & Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$applyAssignments$2(colExpr, assignment)));
        if (exactAssignments2.size() > 1) {
            String conflictingValuesStr = ((IterableOnceOps)exactAssignments2.map((Function1 & Serializable)x$6 -> x$6.value().sql())).mkString(", ");
            addError.apply((Object)("Multiple assignments for '" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted() + "': " + conflictingValuesStr));
            return colExpr;
        }
        if (exactAssignments2.nonEmpty() && fieldAssignments.nonEmpty()) {
            Seq conflictingAssignments = (Seq)exactAssignments2.$plus$plus((IterableOnce)fieldAssignments);
            String conflictingAssignmentsStr = ((IterableOnceOps)conflictingAssignments.map((Function1 & Serializable)x$7 -> x$7.sql())).mkString(", ");
            addError.apply((Object)("Conflicting assignments for '" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted() + "': " + conflictingAssignmentsStr));
            return colExpr;
        }
        if (exactAssignments2.isEmpty() && fieldAssignments.isEmpty()) {
            return TableOutputResolver$.MODULE$.checkNullability(colExpr, col, this.conf(), colPath);
        }
        if (exactAssignments2.nonEmpty()) {
            if (updateStar && SQLConf$.MODULE$.get().coerceMergeNestedTypes()) {
                Expression value = ((Assignment)exactAssignments2.head()).value();
                DataType dataType = col.dataType();
                if (dataType instanceof StructType) {
                    return this.applyNestedFieldAssignments(col, colExpr, value, addError, colPath, coerceNestedTypes);
                }
                Enumeration.Value coerceMode = coerceNestedTypes ? TableOutputResolver$DefaultValueFillMode$.MODULE$.RECURSE() : TableOutputResolver$DefaultValueFillMode$.MODULE$.NONE();
                return TableOutputResolver$.MODULE$.resolveUpdate("", value, col, this.conf(), addError, colPath, coerceMode);
            }
            Expression value = ((Assignment)exactAssignments2.head()).value();
            Enumeration.Value coerceMode = coerceNestedTypes ? TableOutputResolver$DefaultValueFillMode$.MODULE$.RECURSE() : TableOutputResolver$DefaultValueFillMode$.MODULE$.NONE();
            return TableOutputResolver$.MODULE$.resolveUpdate("", value, col, this.conf(), addError, colPath, coerceMode);
        }
        return this.applyFieldAssignments(col, colExpr, (Seq<Assignment>)fieldAssignments, addError, colPath, coerceNestedTypes);
    }

    private boolean applyAssignments$default$6() {
        return false;
    }

    private boolean applyAssignments$default$7() {
        return false;
    }

    private Expression applyFieldAssignments(Attribute col, Expression colExpr, Seq<Assignment> assignments, Function1<String, BoxedUnit> addError, Seq<String> colPath, boolean coerceNestedTypes) {
        DataType dataType = col.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq<AttributeReference> fieldAttrs = DataTypeUtils$.MODULE$.toAttributes(structType);
            GetStructField[] fieldExprs = (GetStructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int ordinal = tuple2._2$mcI$sp();
                    return new GetStructField(colExpr, ordinal, (Option<String>)new Some((Object)field.name()));
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(GetStructField.class));
            Seq updatedFieldExprs = (Seq)((IterableOps)fieldAttrs.zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fieldExprs))).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    AttributeReference fieldAttr = (AttributeReference)tuple2._1();
                    GetStructField fieldExpr = (GetStructField)tuple2._2();
                    return MODULE$.applyAssignments(fieldAttr, fieldExpr, assignments, addError, (Seq<String>)((Seq)colPath.$colon$plus((Object)fieldAttr.name())), coerceNestedTypes, MODULE$.applyAssignments$default$7());
                }
                throw new MatchError((Object)tuple2);
            });
            return this.toNamedStruct(structType, (Seq<Expression>)updatedFieldExprs);
        }
        addError.apply((Object)("Updating nested fields is only supported for StructType but '" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted() + "' is of type " + dataType));
        return colExpr;
    }

    private Expression applyNestedFieldAssignments(Attribute col, Expression colExpr, Expression value, Function1<String, BoxedUnit> addError, Seq<String> colPath, boolean coerceNestedTypes) {
        DataType dataType = col.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq<AttributeReference> fieldAttrs = DataTypeUtils$.MODULE$.toAttributes(structType);
            Seq updatedFieldExprs = (Seq)((IterableOps)fieldAttrs.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Expression expression;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                AttributeReference fieldAttr = (AttributeReference)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                Seq fieldPath = (Seq)colPath.$colon$plus((Object)fieldAttr.name());
                GetStructField targetFieldExpr = new GetStructField(colExpr, ordinal, (Option<String>)new Some((Object)fieldAttr.name()));
                DataType dataType = value.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$applyNestedFieldAssignments$2(fieldAttr, f)));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        StructField matchingField = (StructField)some.value();
                        int fieldIndex = structType.fieldIndex(matchingField.name());
                        expression = new GetStructField(value, fieldIndex, (Option<String>)new Some((Object)matchingField.name()));
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        expression = TableOutputResolver$.MODULE$.checkNullability(targetFieldExpr, fieldAttr, MODULE$.conf(), (Seq<String>)fieldPath);
                    }
                } else {
                    addError.apply((Object)("Cannot assign non-struct value to struct field '" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)fieldPath).quoted() + "'"));
                    expression = new Literal(null, fieldAttr.dataType());
                }
                Literal sourceFieldValue = expression;
                DataType dataType2 = fieldAttr.dataType();
                if (dataType2 instanceof StructType) {
                    return MODULE$.applyNestedFieldAssignments(fieldAttr, targetFieldExpr, sourceFieldValue, addError, (Seq<String>)fieldPath, coerceNestedTypes);
                }
                Enumeration.Value coerceMode = coerceNestedTypes ? TableOutputResolver$DefaultValueFillMode$.MODULE$.RECURSE() : TableOutputResolver$DefaultValueFillMode$.MODULE$.NONE();
                return TableOutputResolver$.MODULE$.resolveUpdate("", sourceFieldValue, fieldAttr, MODULE$.conf(), addError, (Seq<String>)fieldPath, coerceMode);
            });
            Expression namedStruct = this.toNamedStruct(structType, (Seq<Expression>)updatedFieldExprs);
            return this.fixNullExpansion(colExpr, value, structType, namedStruct, colPath);
        }
        addError.apply((Object)("Updating nested fields is only supported for StructType but '" + CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted() + "' is of type " + dataType));
        return colExpr;
    }

    private Expression toNamedStruct(StructType structType, Seq<Expression> fieldExprs) {
        ArraySeq namedStructExprs = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), fieldExprs)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return new .colon.colon((Object)Literal$.MODULE$.apply(field.name()), (List)new .colon.colon((Object)expr, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Expression.class))).toImmutableArraySeq();
        return new CreateNamedStruct((Seq<Expression>)namedStructExprs);
    }

    private boolean hasExtraTargetFields(StructType targetType, DataType sourceType) {
        DataType dataType = sourceType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])targetType.fields()), (Function1 & Serializable)targetField -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$hasExtraTargetFields$1(structType, targetField)));
        }
        throw SparkException$.MODULE$.internalError("Source type must be StructType but found: " + sourceType);
    }

    private Expression fixNullExpansion(Expression key, Expression value, StructType structType, Expression structExpression, Seq<String> colPath) {
        if (key.nullable()) {
            Expression condition = this.hasExtraTargetFields(structType, value.dataType()) ? new And(new IsNull(value), new IsNull(key)) : new IsNull(value);
            return new If(condition, new Literal(null, structExpression.dataType()), structExpression);
        }
        return structExpression;
    }

    public boolean aligned(Seq<Attribute> attrs2, Seq<Assignment> assignments) {
        if (attrs2.size() != assignments.size()) {
            return false;
        }
        return ((IterableOnceOps)attrs2.zip(assignments)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$aligned$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$alignInsertAssignments$1(Assignment assignment) {
        return assignment.key() instanceof Attribute;
    }

    public static final /* synthetic */ boolean $anonfun$applyAssignments$1(Expression colExpr$1, Assignment assignment) {
        return assignment.key().semanticEquals(colExpr$1);
    }

    public static final /* synthetic */ boolean $anonfun$applyAssignments$2(Expression colExpr$1, Assignment assignment) {
        return assignment.key().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.semanticEquals(colExpr$1)));
    }

    public static final /* synthetic */ boolean $anonfun$applyNestedFieldAssignments$2(AttributeReference fieldAttr$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)f.name(), (Object)fieldAttr$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$hasExtraTargetFields$2(StructField targetField$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)f.name(), (Object)targetField$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$hasExtraTargetFields$1(StructType x2$1, StructField targetField) {
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])x2$1.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$hasExtraTargetFields$2(targetField, f)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField sourceField = (StructField)some.value();
            Tuple2 tuple2 = new Tuple2((Object)targetField.dataType(), (Object)sourceField.dataType());
            if (tuple2 != null) {
                DataType targetNested = (DataType)tuple2._1();
                DataType sourceNested = (DataType)tuple2._2();
                if (targetNested instanceof StructType) {
                    StructType structType = (StructType)targetNested;
                    return MODULE$.hasExtraTargetFields(structType, sourceNested);
                }
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$aligned$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Attribute attr = (Attribute)tuple2._1();
        Assignment assignment = (Assignment)tuple2._2();
        DataType attrType = (DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable)() -> attr.dataType());
        Expression expression = assignment.key();
        if (!(expression instanceof Attribute)) return false;
        Attribute attribute = (Attribute)expression;
        if (!BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)attribute.name(), (Object)attr.name()))) return false;
        boolean bl = true;
        boolean isMatchingAssignment = bl;
        if (!isMatchingAssignment) return false;
        if (!DataType$.MODULE$.equalsIgnoreCompatibleNullability(assignment.value().dataType(), attrType)) return false;
        if (attr.nullable()) return true;
        if (assignment.value().nullable()) return false;
        return true;
    }

    private AssignmentUtils$() {
    }
}

