/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.spark.SSLOptions;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleChecksumBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$mcJ$sp;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r\rc!\u0002\u001c8\u0001ez\u0004\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011e\u0003!\u00111A\u0005\u0002iC\u0001\"\u0019\u0001\u0003\u0002\u0004%\tA\u0019\u0005\tQ\u0002\u0011\t\u0011)Q\u00057\"A\u0011\u000e\u0001BC\u0002\u0013\u0005!\u000eC\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005W\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0004\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u000f\u0001A\u0011AA\f\u0011\u001d\t9\u0001\u0001C\u0001\u0003;A\u0011\"!\u000b\u0001\u0011\u000b\u0007I\u0011\u0002.\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\f\t\u0013\u0005}\u0002A1A\u0005\n\u0005\u0005\u0003\u0002CA%\u0001\u0001\u0006I!a\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0003\u0002CA+\u0001\u0001\u0006I!a\u0014\t\u0015\u0005]\u0003\u0001#b\u0001\n\u0013\tI\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"I\u0011Q\u0015\u0001C\u0002\u0013%\u0011q\u0015\u0005\t\u0003#\u0004\u0001\u0015!\u0003\u0002*\"9\u00111\u001b\u0001\u0005B\u0005U\u0007bBAq\u0001\u0011%\u00111\u001d\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\t\t\b\u0001C\u0001\u0003[Dq!a@\u0001\t\u0003\u0011\t\u0001C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u0003\f!9!\u0011\u0005\u0001\u0005\n\t\r\u0002\"\u0003B\u001b\u0001E\u0005I\u0011\u0002B\u0006\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sA\u0011B!\u0012\u0001#\u0003%IAa\u0003\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J!I!Q\u000b\u0001\u0012\u0002\u0013%!1\u0002\u0005\b\u0005/\u0002A\u0011\u0001B-\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqA!\u001d\u0001\t\u0003\u0012\u0019\bC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!q\u001a\u0001\u0005\n\tE\u0007b\u0002Br\u0001\u0011\u0005#Q\u001d\u0005\b\u0005g\u0004A\u0011\tB{\u0011!\u0019)\u0001\u0001C\u0001o\r\u001d\u0001bBB\t\u0001\u0011\u000511\u0003\u0005\n\u0007;\u0001\u0011\u0013!C\u0001\u0005\u0017Aqaa\b\u0001\t\u0003\u001a\t\u0003C\u0004\u0004(\u0001!\te!\u000b\t\u000f\rE\u0002\u0001\"\u0011\u00044\u001dA1QG\u001c\t\u0002e\u001a9DB\u00047o!\u0005\u0011h!\u000f\t\u000f\u0005\u001d!\u0007\"\u0001\u0004<!I1Q\b\u001aC\u0002\u0013\u00051q\b\u0005\b\u0007\u0003\u0012\u0004\u0015!\u0003v\u0005eIe\u000eZ3y'\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u000b\u0005aJ\u0014aB:ik\u001a4G.\u001a\u0006\u0003um\nQa\u001d9be.T!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sON)\u0001\u0001\u0011$K!B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\u0004\"a\u0012%\u000e\u0003]J!!S\u001c\u0003)MCWO\u001a4mK\ncwnY6SKN|GN^3s!\tYe*D\u0001M\u0015\ti\u0015(\u0001\u0005j]R,'O\\1m\u0013\tyEJA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u001d\u000b\u0016B\u0001*8\u0005Ii\u0015n\u001a:bi\u0006\u0014G.\u001a*fg>dg/\u001a:\u0002\t\r|gNZ\u0002\u0001!\t1v+D\u0001:\u0013\tA\u0016HA\u0005Ta\u0006\u00148nQ8oM\u0006iqL\u00197pG.l\u0015M\\1hKJ,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=f\nqa\u001d;pe\u0006<W-\u0003\u0002a;\na!\t\\8dW6\u000bg.Y4fe\u0006\trL\u00197pG.l\u0015M\\1hKJ|F%Z9\u0015\u0005\r4\u0007CA!e\u0013\t)'I\u0001\u0003V]&$\bbB4\u0004\u0003\u0003\u0005\raW\u0001\u0004q\u0012\n\u0014AD0cY>\u001c7.T1oC\u001e,'\u000fI\u0001\u0015i\u0006\u001c8.\u00133NCB\u001chi\u001c:TQV4g\r\\3\u0016\u0003-\u0004B\u0001\\:vq6\tQN\u0003\u0002o_\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\f\u0018\u0001B;uS2T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u[\ni1i\u001c8dkJ\u0014XM\u001c;NCB\u0004\"!\u0011<\n\u0005]\u0014%aA%oiB\u0019\u00110`@\u000e\u0003iT!a\u001f?\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002qs%\u0011aP\u001f\u0002\f\u001fB,g\u000eS1tQN+G\u000fE\u0002B\u0003\u0003I1!a\u0001C\u0005\u0011auN\\4\u0002+Q\f7o[%e\u001b\u0006\u00048OR8s'\",hM\u001a7fA\u00051A(\u001b8jiz\"\u0002\"a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003\u000f\u0002AQaU\u0004A\u0002UCQ!W\u0004A\u0002mCQ![\u0004A\u0002-$B!a\u0003\u0002\u0016!)1\u000b\u0003a\u0001+R1\u00111BA\r\u00037AQaU\u0005A\u0002UCQ!W\u0005A\u0002m#b!a\u0003\u0002 \u0005\u0005\u0002\"B*\u000b\u0001\u0004)\u0006BB5\u000b\u0001\u0004\t\u0019\u0003E\u0003m\u0003K)\b0C\u0002\u0002(5\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u00035!(/\u00198ta>\u0014HoQ8oMV\u0011\u0011q\u0006\t\u0005\u0003c\tI$\u0004\u0002\u00024)\u0019\u0001/!\u000e\u000b\u0007\u0005]\u0012(A\u0004oKR<xN]6\n\t\u0005m\u00121\u0007\u0002\u000e)J\fgn\u001d9peR\u001cuN\u001c4\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA\u0005!\"/Z7pi\u0016\u001c\u0006.\u001e4gY\u0016l\u0015\r\u001f#jg.,\"!a\u0011\u0011\t\u0005\u000b)e`\u0005\u0004\u0003\u000f\u0012%AB(qi&|g.A\u000bsK6|G/Z*ik\u001a4G.Z'bq\u0012K7o\u001b\u0011\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\"!a\u0014\u0011\u0007\u0005\u000b\t&C\u0002\u0002T\t\u0013qAQ8pY\u0016\fg.\u0001\tdQ\u0016\u001c7n];n\u000b:\f'\r\\3eA\u0005I\u0011\r\\4pe&$\b.\\\u000b\u0003\u00037\u0002B!!\u0018\u0002l9!\u0011qLA4!\r\t\tGQ\u0007\u0003\u0003GR1!!\u001aU\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u000e\"\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIGQ\u0001\fO\u0016$H)\u0019;b\r&dW\r\u0006\u0004\u0002v\u0005\u0005\u0015Q\u0011\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P9\u0002\u0005%|\u0017\u0002BA@\u0003s\u0012AAR5mK\"1\u00111Q\nA\u0002U\f\u0011b\u001d5vM\u001adW-\u00133\t\r\u0005\u001d5\u00031\u0001\u0000\u0003\u0015i\u0017\r]%e\u0003E9W\r^*u_J,Gm\u00155vM\u001adWm\u001d\u000b\u0003\u0003\u001b\u0003b!a$\u0002\u001a\u0006}e\u0002BAI\u0003+sA!!\u0019\u0002\u0014&\t1)C\u0002\u0002\u0018\n\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%aA*fc*\u0019\u0011q\u0013\"\u0011\u0007\u001d\u000b\t+C\u0002\u0002$^\u0012\u0001c\u00155vM\u001adWM\u00117pG.LeNZ8\u0002!MDWO\u001a4mK&#7\u000fV8TW&\u0004XCAAU!!\tY+!0\u0002B\u00065WBAAW\u0015\u0011\ty+!-\u0002\u000b\r\f7\r[3\u000b\t\u0005M\u0016QW\u0001\u0007G>lWn\u001c8\u000b\t\u0005]\u0016\u0011X\u0001\u0007O>|w\r\\3\u000b\u0005\u0005m\u0016aA2p[&!\u0011qXAW\u0005\u0015\u0019\u0015m\u00195f!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAdc\u0006!A.\u00198h\u0013\u0011\tY-!2\u0003\u000f%sG/Z4feB!\u00111YAh\u0013\u0011\t\u0019&!2\u0002#MDWO\u001a4mK&#7\u000fV8TW&\u0004\b%\u0001\tbI\u0012\u001c\u0006.\u001e4gY\u0016$vnU6jaR\u00191-a6\t\u000f\u0005\ru\u00031\u0001\u0002ZB!\u00111\\Ao\u001b\u0005\u0001\u0011bAAp\u0011\nI1\u000b[;gM2,\u0017\nZ\u0001\u0016O\u0016$8\u000b[;gM2,')\u001f;fgN#xN]3e)\u0005y\u0018AD2sK\u0006$X\rV3na\u001aKG.\u001a\u000b\u0005\u0003k\nI\u000fC\u0004\u0002lf\u0001\r!!\u001e\u0002\t\u0019LG.\u001a\u000b\t\u0003k\ny/!=\u0002t\"1\u00111\u0011\u000eA\u0002UDa!a\"\u001b\u0001\u0004y\bbBA{5\u0001\u0007\u0011q_\u0001\u0005I&\u00148\u000fE\u0003B\u0003\u000b\nI\u0010E\u0003B\u0003w\fY&C\u0002\u0002~\n\u0013Q!\u0011:sCf\fAbZ3u\u0013:$W\r\u001f$jY\u0016$\u0002\"!\u001e\u0003\u0004\t\u0015!q\u0001\u0005\u0007\u0003\u0007[\u0002\u0019A;\t\r\u0005\u001d5\u00041\u0001\u0000\u0011%\t)p\u0007I\u0001\u0002\u0004\t90\u0001\fhKRLe\u000eZ3y\r&dW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iA\u000b\u0003\u0002x\n=1F\u0001B\t!\u0011\u0011\u0019B!\b\u000e\u0005\tU!\u0002\u0002B\f\u00053\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm!)\u0001\u0006b]:|G/\u0019;j_:LAAa\b\u0003\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\u001d,G/T3sO\u0016$'\t\\8dW\u0012\u000bG/\u0019$jY\u0016$B\"!\u001e\u0003&\t%\"1\u0006B\u0018\u0005gAqAa\n\u001e\u0001\u0004\tY&A\u0003baBLE\r\u0003\u0004\u0002\u0004v\u0001\r!\u001e\u0005\u0007\u0005[i\u0002\u0019A;\u0002\u001dMDWO\u001a4mK6+'oZ3JI\"1!\u0011G\u000fA\u0002U\f\u0001B]3ek\u000e,\u0017\n\u001a\u0005\n\u0003kl\u0002\u0013!a\u0001\u0003o\f\u0001eZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7\u000eR1uC\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u00059r-\u001a;NKJ<W\r\u001a\"m_\u000e\\\u0017J\u001c3fq\u001aKG.\u001a\u000b\r\u0003k\u0012YD!\u0010\u0003@\t\u0005#1\t\u0005\b\u0005Oy\u0002\u0019AA.\u0011\u0019\t\u0019i\ba\u0001k\"1!QF\u0010A\u0002UDaA!\r \u0001\u0004)\b\"CA{?A\u0005\t\u0019AA|\u0003\u0005:W\r^'fe\u001e,GM\u00117pG.Le\u000eZ3y\r&dW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003Y9W\r^'fe\u001e,GM\u00117pG.lU\r^1GS2,G\u0003DA;\u0005\u0017\u0012iEa\u0014\u0003R\tM\u0003b\u0002B\u0014C\u0001\u0007\u00111\f\u0005\u0007\u0003\u0007\u000b\u0003\u0019A;\t\r\t5\u0012\u00051\u0001v\u0011\u0019\u0011\t$\ta\u0001k\"I\u0011Q_\u0011\u0011\u0002\u0003\u0007\u0011q_\u0001!O\u0016$X*\u001a:hK\u0012\u0014En\\2l\u001b\u0016$\u0018MR5mK\u0012\"WMZ1vYR$S'A\bsK6|g/\u001a#bi\u0006\u0014\u00150T1q)\u0015\u0019'1\fB/\u0011\u0019\t\u0019i\ta\u0001k\"1\u0011qQ\u0012A\u0002}\fQc\u00195fG.Le\u000eZ3y\u0003:$G)\u0019;b\r&dW\r\u0006\u0005\u0003d\t\u0015$\u0011\u000eB7!\u0011\t\u00151`@\t\u000f\t\u001dD\u00051\u0001\u0002v\u0005)\u0011N\u001c3fq\"9!1\u000e\u0013A\u0002\u0005U\u0014\u0001\u00023bi\u0006DaAa\u001c%\u0001\u0004)\u0018A\u00022m_\u000e\\7/A\fqkR\u001c\u0006.\u001e4gY\u0016\u0014En\\2l\u0003N\u001cFO]3b[R1!Q\u000fBA\u0005\u0017\u0003BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0005\u0005w\n)$\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005\u007f\u0012IH\u0001\u000bTiJ,\u0017-\\\"bY2\u0014\u0017mY6XSRD\u0017\n\u0012\u0005\b\u0005\u0007+\u0003\u0019\u0001BC\u0003\u001d\u0011Gn\\2l\u0013\u0012\u00042\u0001\u0018BD\u0013\r\u0011I)\u0018\u0002\b\u00052|7m[%e\u0011\u001d\u0011i)\na\u0001\u0005\u001f\u000b\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\u0011\u0011\tJa&\u000e\u0005\tM%b\u0001BKs\u0005Q1/\u001a:jC2L'0\u001a:\n\t\te%1\u0013\u0002\u0012'\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\u0018AE4fi6KwM]1uS>t'\t\\8dWN$BAa(\u00038B1\u0011q\u0012BQ\u0005KKAAa)\u0002\u001e\n!A*[:u!\u001d\t%q\u0015BC\u0005WK1A!+C\u0005\u0019!V\u000f\u001d7feA!!Q\u0016BZ\u001b\t\u0011yK\u0003\u0003\u00032\u0006U\u0012A\u00022vM\u001a,'/\u0003\u0003\u00036\n=&!D'b]\u0006<W\r\u001a\"vM\u001a,'\u000fC\u0004\u0003:\u001a\u0002\r!a(\u0002!MDWO\u001a4mK\ncwnY6J]\u001a|\u0017AG<sSR,W*\u001a;bI\u0006$\u0018MR5mK\u0006sGmQ8n[&$HcC2\u0003@\n\u0005'1\u0019Bd\u0005\u0017Da!a!(\u0001\u0004)\bBBADO\u0001\u0007q\u0010C\u0004\u0003F\u001e\u0002\rAa\u0019\u0002\u000f1,gn\u001a;ig\"9!\u0011Z\u0014A\u0002\t\r\u0014!C2iK\u000e\\7/^7t\u0011\u001d\u0011im\na\u0001\u0003k\nq\u0001Z1uCRk\u0007/A\txe&$X-T3uC\u0012\fG/\u0019$jY\u0016$\u0012b\u0019Bj\u0005/\u0014YNa8\t\u000f\tU\u0007\u00061\u0001\u0003d\u0005QQ.\u001a;b-\u0006dW/Z:\t\u000f\te\u0007\u00061\u0001\u0002v\u00059A/\u001c9GS2,\u0007b\u0002BoQ\u0001\u0007\u0011QO\u0001\u000bi\u0006\u0014x-\u001a;GS2,\u0007b\u0002BqQ\u0001\u0007\u0011qJ\u0001\u000faJ|\u0007/Y4bi\u0016,%O]8s\u0003I9W\r^'fe\u001e,GM\u00117pG.$\u0015\r^1\u0015\r\t\u001d(\u0011\u001eBy!\u0019\ty)!'\u0003,\"9!1Q\u0015A\u0002\t-\bc\u0001/\u0003n&\u0019!q^/\u0003)MCWO\u001a4mK6+'oZ3e\u00052|7m[%e\u0011\u001d\t)0\u000ba\u0001\u0003o\f!cZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7.T3uCR1!q_B\u0001\u0007\u0007\u0001BA!?\u0003~6\u0011!1 \u0006\u0004q\u0005U\u0012\u0002\u0002B\u0000\u0005w\u0014q\"T3sO\u0016$'\t\\8dW6+G/\u0019\u0005\b\u0005\u0007S\u0003\u0019\u0001Bv\u0011\u001d\t)P\u000ba\u0001\u0003o\fAbZ3u\u0007\",7m[:v[N$bAa\u0019\u0004\n\r5\u0001bBB\u0006W\u0001\u0007\u0011QO\u0001\rG\",7m[:v[\u001aKG.\u001a\u0005\u0007\u0007\u001fY\u0003\u0019A;\u0002\u0011\tdwnY6Ok6\fqbZ3u\u0007\",7m[:v[\u001aKG.\u001a\u000b\u000b\u0003k\u001a)ba\u0006\u0004\u001a\rm\u0001BBABY\u0001\u0007Q\u000f\u0003\u0004\u0002\b2\u0002\ra \u0005\b\u0003/b\u0003\u0019AA.\u0011%\t)\u0010\fI\u0001\u0002\u0004\t90A\rhKR\u001c\u0005.Z2lgVlg)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014\u0001D4fi\ncwnY6ECR\fGC\u0002BV\u0007G\u0019)\u0003C\u0004\u0003\u0004:\u0002\rA!\"\t\u0013\u0005Uh\u0006%AA\u0002\u0005]\u0018aE4fi\ncwnY6t\r>\u00148\u000b[;gM2,GCBB\u0016\u0007[\u0019y\u0003\u0005\u0004\u0002\u0010\u0006e%Q\u0011\u0005\u0007\u0003\u0007{\u0003\u0019A;\t\r\u0005\u001du\u00061\u0001\u0000\u0003\u0011\u0019Ho\u001c9\u0015\u0003\r\f\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<feB\u0011qIM\n\u0003e\u0001#\"aa\u000e\u0002\u001d9{u\nU0S\u000b\u0012+6)R0J\tV\tQ/A\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#!\u0001")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging,
MigratableResolver {
    private BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    private String algorithm;
    private final SparkConf conf;
    private BlockManager _blockManager;
    private final ConcurrentMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle;
    private final TransportConf transportConf;
    private final Option<Object> remoteShuffleMaxDisk;
    private final boolean checksumEnabled;
    private final Cache<Integer, Boolean> shuffleIdsToSkip;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManager _blockManager() {
        return this._blockManager;
    }

    public void _blockManager_$eq(BlockManager x$1) {
        this._blockManager = x$1;
    }

    public ConcurrentMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle() {
        return this.taskIdMapsForShuffle;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager()).getOrElse((Function0 & Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    public BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.blockManager$lzycompute();
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private Option<Object> remoteShuffleMaxDisk() {
        return this.remoteShuffleMaxDisk;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private String algorithm$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.algorithm = this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.algorithm;
    }

    private String algorithm() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.algorithm$lzycompute();
        }
        return this.algorithm;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    @Override
    public Seq<ShuffleBlockInfo> getStoredShuffles() {
        Seq<BlockId> allBlocks = this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getAllBlocks();
        return (Seq)allBlocks.flatMap((Function1 & Serializable)x0$1 -> {
            BlockId blockId = x0$1;
            if (blockId instanceof ShuffleIndexBlockId) {
                ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                int shuffleId = shuffleIndexBlockId.shuffleId();
                long mapId = shuffleIndexBlockId.mapId();
                if (Option$.MODULE$.apply(this.shuffleIdsToSkip().getIfPresent((Object)BoxesRunTime.boxToInteger((int)shuffleId))).isEmpty()) {
                    return new Some((Object)new ShuffleBlockInfo(shuffleId, mapId));
                }
            }
            return None$.MODULE$;
        });
    }

    private Cache<Integer, Boolean> shuffleIdsToSkip() {
        return this.shuffleIdsToSkip;
    }

    @Override
    public void addShuffleToSkip(int shuffleId) {
        this.shuffleIdsToSkip().put((Object)Predef$.MODULE$.int2Integer(shuffleId), (Object)Predef$.MODULE$.boolean2Boolean(true));
    }

    private long getShuffleBytesStored() {
        Seq shuffleFiles = (Seq)this.getStoredShuffles().map((Function1 & Serializable)si -> this.getDataFile(si.shuffleId(), si.mapId()));
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)shuffleFiles.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public File createTempFile(File file) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().createTempFileWith(file);
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    private File getMergedBlockDataFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedDataBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private File getMergedBlockIndexFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedIndexBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private Option<String[]> getMergedBlockIndexFile$default$5() {
        return None$.MODULE$;
    }

    private File getMergedBlockMetaFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedMetaBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting data ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, ((File)file$1.elem).getPath())}))));
        }
        file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting index ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, ((File)file$1.elem).getPath())}))));
        }
        if (this.checksumEnabled()) {
            file.elem = this.getChecksumFile(shuffleId, mapId, this.algorithm(), this.getChecksumFile$default$4());
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting checksum ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, ((File)file$1.elem).getPath())}))));
                return;
            }
            return;
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block12: {
            long[] lArray;
            block11: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block11;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        if (data.length() == BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(lengths).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))) {
            return lengths;
        }
        return null;
    }

    @Override
    public StreamCallbackWithID putShuffleBlockAsStream(BlockId blockId, SerializerManager serializerManager) {
        File file;
        this.remoteShuffleMaxDisk().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)maxBytes -> {
            long bytesUsed = this.getShuffleBytesStored();
            if (maxBytes < bytesUsed) {
                throw SparkException$.MODULE$.internalError("Not storing remote shuffles " + bytesUsed + " exceeds " + maxBytes, "SHUFFLE");
            }
        });
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleIndexBlockId) {
            ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId2;
            int shuffleId = shuffleIndexBlockId.shuffleId();
            long mapId = shuffleIndexBlockId.mapId();
            file = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        } else if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            file = this.getDataFile(shuffleId, mapId);
        } else {
            throw SparkException$.MODULE$.internalError("Unexpected shuffle block transfer " + blockId + " as " + blockId.getClass().getSimpleName(), "SHUFFLE");
        }
        File file2 = file;
        File fileTmp = this.createTempFile(file2);
        WritableByteChannel channel = Channels.newChannel(new FileOutputStream(fileTmp));
        return new StreamCallbackWithID(this, blockId, channel, fileTmp, file2){
            private final /* synthetic */ IndexShuffleBlockResolver $outer;
            private final BlockId blockId$3;
            private final WritableByteChannel channel$1;
            private final File fileTmp$1;
            private final File file$2;

            public ByteBuffer getCompletionResponse() {
                return super.getCompletionResponse();
            }

            public String getID() {
                return this.blockId$3.name();
            }

            public void onData(String streamId, ByteBuffer buf) {
                while (buf.hasRemaining()) {
                    this.channel$1.write(buf);
                }
            }

            public void onComplete(String streamId) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable)() -> "Done receiving shuffle block " + $this.blockId$3 + ", now storing on local disk.");
                this.channel$1.close();
                long diskSize = this.fileTmp$1.length();
                $anon$1 var5_3 = this;
                synchronized (var5_3) {
                    Object object = this.file$2.exists() ? BoxesRunTime.boxToBoolean((boolean)this.file$2.delete()) : BoxedUnit.UNIT;
                    if (!this.fileTmp$1.renameTo(this.file$2)) {
                        throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(this.fileTmp$1, this.file$2);
                    }
                }
                BlockId blockId = this.blockId$3;
                if (blockId instanceof ShuffleIndexBlockId) {
                    OpenHashSet mapTaskIds;
                    ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                    int shuffleId = shuffleIndexBlockId.shuffleId();
                    long mapId = shuffleIndexBlockId.mapId();
                    OpenHashSet openHashSet = mapTaskIds = this.$outer.taskIdMapsForShuffle().computeIfAbsent(BoxesRunTime.boxToInteger((int)shuffleId), x$2 -> $anon$1.$anonfun$onComplete$2(BoxesRunTime.unboxToInt((Object)x$2)));
                    synchronized (openHashSet) {
                        mapTaskIds.add$mcJ$sp(mapId);
                    }
                }
                if (blockId instanceof ShuffleDataBlockId) {
                    OpenHashSet mapTaskIds;
                    ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId;
                    int shuffleId = shuffleDataBlockId.shuffleId();
                    long mapId = shuffleDataBlockId.mapId();
                    OpenHashSet openHashSet = mapTaskIds = this.$outer.taskIdMapsForShuffle().computeIfAbsent(BoxesRunTime.boxToInteger((int)shuffleId), x$3 -> $anon$1.$anonfun$onComplete$3(BoxesRunTime.unboxToInt((Object)x$3)));
                    synchronized (openHashSet) {
                        mapTaskIds.add$mcJ$sp(mapId);
                    }
                }
                this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus(this.blockId$3, new BlockStatus(StorageLevel$.MODULE$.DISK_ONLY(), 0L, diskSize), this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus$default$3());
            }

            public void onFailure(String streamId, Throwable cause) {
                this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error while uploading ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.BLOCK_ID, $this.blockId$3)}))), cause);
                this.channel$1.close();
                this.fileTmp$1.delete();
            }

            public static final /* synthetic */ OpenHashSet $anonfun$onComplete$2(int x$2) {
                return new OpenHashSet$mcJ$sp(8, (ClassTag<Object>)ClassTag$.MODULE$.Long());
            }

            public static final /* synthetic */ OpenHashSet $anonfun$onComplete$3(int x$3) {
                return new OpenHashSet$mcJ$sp(8, (ClassTag<Object>)ClassTag$.MODULE$.Long());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
                this.channel$1 = channel$1;
                this.fileTmp$1 = fileTmp$1;
                this.file$2 = file$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 ), $anonfun$onFailure$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 )}, serializedLambda);
            }
        };
    }

    @Override
    public List<Tuple2<BlockId, ManagedBuffer>> getMigrationBlocks(ShuffleBlockInfo shuffleBlockInfo) {
        List list;
        block4: {
            try {
                int shuffleId = shuffleBlockInfo.shuffleId();
                long mapId = shuffleBlockInfo.mapId();
                File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                long indexFileSize = indexFile.length();
                FileSegmentManagedBuffer indexBlockData = new FileSegmentManagedBuffer(this.transportConf(), indexFile, 0L, indexFileSize);
                File dataFile = this.getDataFile(shuffleId, mapId);
                ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                FileSegmentManagedBuffer dataBlockData = new FileSegmentManagedBuffer(this.transportConf(), dataFile, 0L, dataFile.length());
                if (!indexFile.exists()) {
                    throw SparkException$.MODULE$.internalError("Index file is deleted already.", "SHUFFLE");
                }
                if (dataFile.exists()) {
                    list = new .colon.colon((Object)new Tuple2((Object)dataBlockId, (Object)dataBlockData), (List)new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$));
                    break block4;
                }
                list = new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$);
            }
            catch (Exception exception) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve shuffle block "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SHUFFLE_BLOCK_INFO, shuffleBlockInfo)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This is expected to occur if a block is removed after decommissioning has started."}))).log((Seq)Nil$.MODULE$))));
                list = package$.MODULE$.List().empty();
            }
        }
        return list;
    }

    public void writeMetadataFileAndCommit(int shuffleId, long mapId, long[] lengths, long[] checksums, File dataTmp) {
        Tuple2 tuple2;
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = this.createTempFile(indexFile);
        boolean checksumEnabled = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(checksums));
        if (checksumEnabled) {
            Predef$.MODULE$.assert(lengths.length == checksums.length, (Function0 & Serializable)() -> "The size of partition lengths and checksums should be equal");
            File checksumFile = this.getChecksumFile(shuffleId, mapId, this.algorithm(), this.getChecksumFile$default$4());
            v0 = new Tuple2((Object)new Some((Object)checksumFile), (Object)new Some((Object)this.createTempFile(checksumFile)));
        } else {
            v0 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option checksumFileOpt = (Option)tuple2._1();
        Option checksumTmpOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)checksumFileOpt, (Object)checksumTmpOpt);
        Option checksumFileOpt2 = (Option)tuple22._1();
        Option checksumTmpOpt2 = (Option)tuple22._2();
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    if (checksumEnabled) {
                        long[] existingChecksums = this.getChecksums((File)checksumFileOpt2.get(), checksums.length);
                        if (existingChecksums != null) {
                            System.arraycopy(existingChecksums, 0, checksums, 0, lengths.length);
                        } else {
                            this.writeMetadataFile(checksums, (File)checksumTmpOpt2.get(), (File)checksumFileOpt2.get(), false);
                        }
                    }
                    v1 = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    long[] offsets = (long[])ArrayOps$.MODULE$.scanLeft$extension(Predef$.MODULE$.longArrayOps(lengths), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$5, x$6) -> x$5 + x$6, (ClassTag)ClassTag$.MODULE$.Long());
                    this.writeMetadataFile(offsets, indexTmp, indexFile, true);
                    Object object = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(dataTmp, dataFile);
                    }
                    checksumTmpOpt2.zip(checksumFileOpt2).foreach((Function1 & Serializable)x0$1 -> {
                        IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$3(this, checksums, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    v1 = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Shuffle index for mapId " + mapId + ": " + Predef$.MODULE$.wrapLongArray(lengths).mkString("[", ",", "]"));
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete temporary index file at "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, indexTmp.getAbsolutePath())})))));
            }
            checksumTmpOpt2.foreach((Function1 & Serializable)checksumTmp -> {
                IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$7(this, checksumTmp);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void writeMetadataFile(long[] metaValues, File tmpFile, File targetFile, boolean propagateError) {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(metaValues), (Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> out.writeLong(x$1)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> out.close());
        Object object = targetFile.exists() ? BoxesRunTime.boxToBoolean((boolean)targetFile.delete()) : BoxedUnit.UNIT;
        if (!tmpFile.renameTo(targetFile)) {
            if (propagateError) {
                throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(tmpFile, targetFile);
            }
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fail to rename file ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TEMP_FILE, tmpFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TARGET_PATH, targetFile)})))));
            return;
        }
    }

    @Override
    public Seq<ManagedBuffer> getMergedBlockData(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        File dataFile = this.getMergedBlockDataFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        LongBuffer offsets = (LongBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new DataInputStream(Files.newInputStream(indexFile.toPath(), new OpenOption[0])), (Function1 & Serializable)dis -> {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            dis.readFully(buffer.array());
            return buffer.asLongBuffer();
        });
        int numChunks = size / 8 - 1;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numChunks).map((Function1 & Serializable)index -> IndexShuffleBlockResolver.$anonfun$getMergedBlockData$3(this, dataFile, offsets, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Option<String[]> getMergedBlockDataFile$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        File metaFile = this.getMergedBlockMetaFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.transportConf(), metaFile, 0L, metaFile.length());
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    private Option<String[]> getMergedBlockMetaFile$default$5() {
        return None$.MODULE$;
    }

    public long[] getChecksums(File checksumFile, int blockNum) {
        ArrayBuffer checksums;
        block8: {
            long[] lArray;
            block9: {
                if (!checksumFile.exists()) {
                    return null;
                }
                checksums = new ArrayBuffer();
                try (FilterInputStream in = null;){
                    try {
                        in = new DataInputStream(new NioBufferedFileInputStream(checksumFile));
                        while (checksums.size() < blockNum) {
                            checksums.$plus$eq((Object)BoxesRunTime.boxToLong((long)((DataInputStream)in).readLong()));
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof IOException ? true : throwable2 instanceof EOFException) {
                            lArray = null;
                            break block9;
                        }
                        throw throwable;
                    }
                }
            }
            return lArray;
        }
        return (long[])checksums.toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public File getChecksumFile(int shuffleId, long mapId, String algorithm, Option<String[]> dirs) {
        ShuffleChecksumBlockId blockId = new ShuffleChecksumBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        String fileName = ShuffleChecksumHelper.getChecksumFileName((String)blockId.name(), (String)algorithm);
        return (File)dirs.map((Function1 & Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)fileName))).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(fileName));
    }

    public Option<String[]> getChecksumFile$default$4() {
        return None$.MODULE$;
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw SparkException$.MODULE$.internalError("unexpected shuffle block id format: " + blockId, "SHUFFLE");
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw SparkException$.MODULE$.internalError("SPARK-22982: Incorrect channel position after index file reads: expected " + expectedPosition + " but actual position was " + actualPosition + ".", "SHUFFLE");
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public Seq<BlockId> getBlocksForShuffle(int shuffleId, long mapId) {
        return new .colon.colon((Object)new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)new .colon.colon((Object)new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)Nil$.MODULE$));
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$3(IndexShuffleBlockResolver $this, long[] checksums$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            File checksumTmp = (File)tuple2._1();
            File checksumFile = (File)tuple2._2();
            try {
                $this.writeMetadataFile(checksums$1, checksumTmp, checksumFile, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to write checksum file", (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$7(IndexShuffleBlockResolver $this, File checksumTmp) {
        if (checksumTmp.exists()) {
            try {
                if (!checksumTmp.delete()) {
                    $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete temporary checksum file at "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PATH, checksumTmp.getAbsolutePath())})))));
                }
            }
            catch (Exception e) {
                $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete temporary checksum file "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"at ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PATH, checksumTmp.getAbsolutePath())})))), (Throwable)e);
            }
            return;
        }
    }

    public static final /* synthetic */ FileSegmentManagedBuffer $anonfun$getMergedBlockData$3(IndexShuffleBlockResolver $this, File dataFile$1, LongBuffer offsets$1, int index) {
        return new FileSegmentManagedBuffer($this.transportConf(), dataFile$1, offsets$1.get(index), offsets$1.get(index + 1) - offsets$1.get(index));
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager, ConcurrentMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle) {
        this.conf = conf;
        this._blockManager = _blockManager;
        this.taskIdMapsForShuffle = taskIdMapsForShuffle;
        ShuffleBlockResolver.$init$(this);
        Logging.$init$((Logging)this);
        MigratableResolver.$init$(this);
        SecurityManager securityManager = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        SparkConf x$1 = conf;
        String x$2 = "shuffle";
        Some x$3 = new Some((Object)securityManager.getRpcSSLOptions());
        int x$4 = SparkTransportConf$.MODULE$.fromSparkConf$default$3();
        Option<String> x$5 = SparkTransportConf$.MODULE$.fromSparkConf$default$4();
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(x$1, "shuffle", x$4, x$5, (Option<SSLOptions>)x$3);
        this.remoteShuffleMaxDisk = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_DISK_SIZE());
        this.checksumEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ENABLED()));
        this.shuffleIdsToSkip = CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    public IndexShuffleBlockResolver(SparkConf conf) {
        this(conf, null, new ConcurrentHashMap<Object, OpenHashSet<Object>>());
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this(conf, _blockManager, new ConcurrentHashMap<Object, OpenHashSet<Object>>());
    }

    public IndexShuffleBlockResolver(SparkConf conf, ConcurrentHashMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle) {
        this(conf, null, taskIdMapsForShuffle);
    }
}

