/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TLSRouteRule;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TLSRouteRuleFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendRefBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendRefFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TLSRouteRuleFluentImpl<A extends TLSRouteRuleFluent<A>>
extends BaseFluent<A>
implements TLSRouteRuleFluent<A> {
    private ArrayList<BackendRefBuilder> backendRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public TLSRouteRuleFluentImpl() {
    }

    public TLSRouteRuleFluentImpl(TLSRouteRule instance) {
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").add(index, builder);
            this.backendRefs.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToBackendRefs(int index, BackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        BackendRefBuilder builder = new BackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").set(index, builder);
            this.backendRefs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBackendRefs(BackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBackendRefs(Collection<BackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBackendRefs(BackendRef ... items) {
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove(builder);
            if (this.backendRefs == null) continue;
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBackendRefs(Collection<BackendRef> items) {
        for (BackendRef item : items) {
            BackendRefBuilder builder = new BackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove(builder);
            if (this.backendRefs == null) continue;
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBackendRefs(Predicate<BackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        Iterator<BackendRefBuilder> each = this.backendRefs.iterator();
        List visitables = this._visitables.get((Object)"backendRefs");
        while (each.hasNext()) {
            BackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BackendRef> getBackendRefs() {
        return this.backendRefs != null ? TLSRouteRuleFluentImpl.build(this.backendRefs) : null;
    }

    @Override
    public List<BackendRef> buildBackendRefs() {
        return this.backendRefs != null ? TLSRouteRuleFluentImpl.build(this.backendRefs) : null;
    }

    @Override
    public BackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    @Override
    public BackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    @Override
    public BackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    @Override
    public BackendRef buildMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        for (BackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBackendRefs(List<BackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get((Object)"backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)this;
    }

    @Override
    public A withBackendRefs(BackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove((Object)"backendRefs");
        }
        if (backendRefs != null) {
            for (BackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNestedImpl();
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> addNewBackendRefLike(BackendRef item) {
        return new BackendRefsNestedImpl(-1, item);
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> setNewBackendRefLike(int index, BackendRef item) {
        return new BackendRefsNestedImpl(index, item);
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public TLSRouteRuleFluent.BackendRefsNested<A> editMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching backendRefs. No match found.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSRouteRuleFluentImpl that = (TLSRouteRuleFluentImpl)o;
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.backendRefs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class BackendRefsNestedImpl<N>
    extends BackendRefFluentImpl<TLSRouteRuleFluent.BackendRefsNested<N>>
    implements TLSRouteRuleFluent.BackendRefsNested<N>,
    Nested<N> {
        BackendRefBuilder builder;
        int index;

        BackendRefsNestedImpl(int index, BackendRef item) {
            this.index = index;
            this.builder = new BackendRefBuilder(this, item);
        }

        BackendRefsNestedImpl() {
            this.index = -1;
            this.builder = new BackendRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)TLSRouteRuleFluentImpl.this.setToBackendRefs(this.index, this.builder.build());
        }

        @Override
        public N endBackendRef() {
            return this.and();
        }
    }
}

