/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.kll.KllDoublesQuantileCalculator;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;

final class KllDoublesHelper {
    KllDoublesHelper() {
    }

    static double getDoubleRank(KllSketch mine, double value) {
        if (mine.isEmpty()) {
            return Double.NaN;
        }
        int level = 0;
        int weight = 1;
        long total = 0L;
        double[] myDoubleItemsArr = mine.getDoubleItemsArray();
        int[] myLevelsArr = mine.getLevelsArray();
        while (level < mine.getNumLevels()) {
            int fromIndex = myLevelsArr[level];
            int toIndex = myLevelsArr[level + 1];
            for (int i = fromIndex; i < toIndex; ++i) {
                if (myDoubleItemsArr[i] < value) {
                    total += (long)weight;
                    continue;
                }
                if (level > 0 || mine.isLevelZeroSorted()) break;
            }
            ++level;
            weight *= 2;
        }
        return (double)total / (double)mine.getN();
    }

    static double[] getDoublesPmfOrCdf(KllSketch mine, double[] splitPoints, boolean isCdf) {
        if (mine.isEmpty()) {
            return null;
        }
        KllDoublesHelper.validateDoubleValues(splitPoints);
        double[] buckets = new double[splitPoints.length + 1];
        int myNumLevels = mine.getNumLevels();
        int[] myLevelsArr = mine.getLevelsArray();
        int level = 0;
        int weight = 1;
        while (level < myNumLevels) {
            int fromIndex = myLevelsArr[level];
            int toIndex = myLevelsArr[level + 1];
            if (level == 0 && !mine.isLevelZeroSorted()) {
                KllDoublesHelper.incrementDoublesBucketsUnsortedLevel(mine, fromIndex, toIndex, weight, splitPoints, buckets);
            } else {
                KllDoublesHelper.incrementDoublesBucketsSortedLevel(mine, fromIndex, toIndex, weight, splitPoints, buckets);
            }
            ++level;
            weight *= 2;
        }
        if (isCdf) {
            double subtotal = 0.0;
            for (int i = 0; i < buckets.length; ++i) {
                buckets[i] = (subtotal += buckets[i]) / (double)mine.getN();
            }
        } else {
            int i = 0;
            while (i < buckets.length) {
                int n = i++;
                buckets[n] = buckets[n] / (double)mine.getN();
            }
        }
        return buckets;
    }

    static double getDoublesQuantile(KllSketch mine, double fraction) {
        if (mine.isEmpty()) {
            return Double.NaN;
        }
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero nor greater than 1.0");
        }
        if (fraction == 0.0) {
            return mine.getMinDoubleValue();
        }
        if (fraction == 1.0) {
            return mine.getMaxDoubleValue();
        }
        KllDoublesQuantileCalculator quant = KllDoublesHelper.getDoublesQuantileCalculator(mine);
        return quant.getQuantile(fraction);
    }

    static double[] getDoublesQuantiles(KllSketch mine, double[] fractions) {
        if (mine.isEmpty()) {
            return null;
        }
        KllDoublesQuantileCalculator quant = null;
        double[] quantiles = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction < 0.0 || fraction > 1.0) {
                throw new SketchesArgumentException("Fraction cannot be less than zero nor greater than 1.0");
            }
            if (fraction == 0.0) {
                quantiles[i] = mine.getMinDoubleValue();
                continue;
            }
            if (fraction == 1.0) {
                quantiles[i] = mine.getMaxDoubleValue();
                continue;
            }
            if (quant == null) {
                quant = KllDoublesHelper.getDoublesQuantileCalculator(mine);
            }
            quantiles[i] = quant.getQuantile(fraction);
        }
        return quantiles;
    }

    static void mergeDoubleImpl(KllSketch mine, KllSketch other) {
        double[] otherDoubleItemsArr;
        if (other.isEmpty()) {
            return;
        }
        long finalN = mine.getN() + other.getN();
        int otherNumLevels = other.getNumLevels();
        int[] otherLevelsArr = other.getLevelsArray();
        double myMin = mine.getMinDoubleValue();
        double myMax = mine.getMaxDoubleValue();
        int myMinK = mine.getMinK();
        if (other.isCompactSingleItem()) {
            KllDoublesHelper.updateDouble(mine, other.getDoubleSingleItem());
            otherDoubleItemsArr = new double[]{};
        } else {
            otherDoubleItemsArr = other.getDoubleItemsArray();
            for (int i = otherLevelsArr[0]; i < otherLevelsArr[1]; ++i) {
                KllDoublesHelper.updateDouble(mine, otherDoubleItemsArr[i]);
            }
        }
        int myCurNumLevels = mine.getNumLevels();
        int[] myCurLevelsArr = mine.getLevelsArray();
        double[] myCurDoubleItemsArr = mine.getDoubleItemsArray();
        int myNewNumLevels = myCurNumLevels;
        int[] myNewLevelsArr = myCurLevelsArr;
        double[] myNewDoubleItemsArr = myCurDoubleItemsArr;
        if (otherNumLevels > 1 && !other.isCompactSingleItem()) {
            int tmpSpaceNeeded = mine.getNumRetained() + KllHelper.getNumRetainedAboveLevelZero(otherNumLevels, otherLevelsArr);
            double[] workbuf = new double[tmpSpaceNeeded];
            int ub = KllHelper.ubOnNumLevels(finalN);
            int[] worklevels = new int[ub + 2];
            int[] outlevels = new int[ub + 2];
            int provisionalNumLevels = Math.max(myCurNumLevels, otherNumLevels);
            KllDoublesHelper.populateDoubleWorkArrays(workbuf, worklevels, provisionalNumLevels, myCurNumLevels, myCurLevelsArr, myCurDoubleItemsArr, otherNumLevels, otherLevelsArr, otherDoubleItemsArr);
            int[] result = KllDoublesHelper.generalDoublesCompress(mine.getK(), mine.getM(), provisionalNumLevels, workbuf, worklevels, workbuf, outlevels, mine.isLevelZeroSorted(), KllSketch.random);
            int targetItemCount = result[1];
            int curItemCount = result[2];
            myNewNumLevels = result[0];
            assert (myNewNumLevels <= ub);
            myNewDoubleItemsArr = targetItemCount == myCurDoubleItemsArr.length ? myCurDoubleItemsArr : new double[targetItemCount];
            int freeSpaceAtBottom = targetItemCount - curItemCount;
            System.arraycopy(workbuf, outlevels[0], myNewDoubleItemsArr, freeSpaceAtBottom, curItemCount);
            int theShift = freeSpaceAtBottom - outlevels[0];
            int finalLevelsArrLen = myCurLevelsArr.length < myNewNumLevels + 1 ? myNewNumLevels + 1 : myCurLevelsArr.length;
            myNewLevelsArr = new int[finalLevelsArrLen];
            for (int lvl = 0; lvl < myNewNumLevels + 1; ++lvl) {
                myNewLevelsArr[lvl] = outlevels[lvl] + theShift;
            }
            if (mine.updatableMemFormat) {
                mine.wmem = KllHelper.memorySpaceMgmt(mine, myNewLevelsArr.length, myNewDoubleItemsArr.length);
            }
        }
        mine.setN(finalN);
        if (other.isEstimationMode()) {
            mine.setMinK(Math.min(myMinK, other.getMinK()));
        }
        mine.setNumLevels(myNewNumLevels);
        mine.setLevelsArray(myNewLevelsArr);
        mine.setDoubleItemsArray(myNewDoubleItemsArr);
        double otherMin = other.getMinDoubleValue();
        double otherMax = other.getMaxDoubleValue();
        mine.setMinDoubleValue(KllDoublesHelper.resolveDoubleMinValue(myMin, otherMin));
        mine.setMaxDoubleValue(KllDoublesHelper.resolveDoubleMaxValue(myMax, otherMax));
        assert (KllHelper.sumTheSampleWeights(mine.getNumLevels(), mine.getLevelsArray()) == mine.getN());
    }

    static void mergeSortedDoubleArrays(double[] bufA, int startA, int lenA, double[] bufB, int startB, int lenB, double[] bufC, int startC) {
        int lenC = lenA + lenB;
        int limA = startA + lenA;
        int limB = startB + lenB;
        int limC = startC + lenC;
        int a = startA;
        int b = startB;
        for (int c = startC; c < limC; ++c) {
            if (a == limA) {
                bufC[c] = bufB[b];
                ++b;
                continue;
            }
            if (b == limB) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            if (bufA[a] < bufB[b]) {
                bufC[c] = bufA[a];
                ++a;
                continue;
            }
            bufC[c] = bufB[b];
            ++b;
        }
        assert (a == limA);
        assert (b == limB);
    }

    static void randomlyHalveDownDoubles(double[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + offset;
        for (int i = start; i < start + half_length; ++i) {
            buf[i] = buf[j];
            j += 2;
        }
    }

    static void randomlyHalveUpDoubles(double[] buf, int start, int length, Random random) {
        assert (Util.isEven(length));
        int half_length = length / 2;
        int offset = random.nextInt(2);
        int j = start + length - 1 - offset;
        for (int i = start + length - 1; i >= start + half_length; --i) {
            buf[i] = buf[j];
            j -= 2;
        }
    }

    static void updateDouble(KllSketch mine, double value) {
        if (Double.isNaN(value)) {
            return;
        }
        double prevMin = mine.getMinDoubleValue();
        double prevMax = mine.getMaxDoubleValue();
        mine.setMinDoubleValue(KllDoublesHelper.resolveDoubleMinValue(prevMin, value));
        mine.setMaxDoubleValue(KllDoublesHelper.resolveDoubleMaxValue(prevMax, value));
        if (mine.getLevelsArray()[0] == 0) {
            KllHelper.compressWhileUpdatingSketch(mine);
        }
        int myLevelsArrAtZero = mine.getLevelsArray()[0];
        mine.incN();
        mine.setLevelZeroSorted(false);
        int nextPos = myLevelsArrAtZero - 1;
        assert (myLevelsArrAtZero >= 0);
        mine.setLevelsArrayAt(0, nextPos);
        mine.setDoubleItemsArrayAt(nextPos, value);
    }

    private static int[] generalDoublesCompress(int k, int m, int numLevelsIn, double[] inBuf, int[] inLevels, double[] outBuf, int[] outLevels, boolean isLevelZeroSorted, Random random) {
        assert (numLevelsIn > 0);
        int numLevels = numLevelsIn;
        int currentItemCount = inLevels[numLevels] - inLevels[0];
        int targetItemCount = KllHelper.computeTotalItemCapacity(k, m, numLevels);
        boolean doneYet = false;
        outLevels[0] = 0;
        int curLevel = -1;
        while (!doneYet) {
            if (++curLevel == numLevels - 1) {
                inLevels[curLevel + 2] = inLevels[curLevel + 1];
            }
            int rawBeg = inLevels[curLevel];
            int rawLim = inLevels[curLevel + 1];
            int rawPop = rawLim - rawBeg;
            if (currentItemCount < targetItemCount || rawPop < KllHelper.levelCapacity(k, numLevels, curLevel, m)) {
                assert (rawBeg >= outLevels[curLevel]);
                System.arraycopy(inBuf, rawBeg, outBuf, outLevels[curLevel], rawPop);
                outLevels[curLevel + 1] = outLevels[curLevel] + rawPop;
            } else {
                int popAbove = inLevels[curLevel + 2] - rawLim;
                boolean oddPop = Util.isOdd(rawPop);
                int adjBeg = oddPop ? 1 + rawBeg : rawBeg;
                int adjPop = oddPop ? rawPop - 1 : rawPop;
                int halfAdjPop = adjPop / 2;
                if (oddPop) {
                    outBuf[outLevels[curLevel]] = inBuf[rawBeg];
                    outLevels[curLevel + 1] = outLevels[curLevel] + 1;
                } else {
                    outLevels[curLevel + 1] = outLevels[curLevel];
                }
                if (curLevel == 0 && !isLevelZeroSorted) {
                    Arrays.sort(inBuf, adjBeg, adjBeg + adjPop);
                }
                if (popAbove == 0) {
                    KllDoublesHelper.randomlyHalveUpDoubles(inBuf, adjBeg, adjPop, random);
                } else {
                    KllDoublesHelper.randomlyHalveDownDoubles(inBuf, adjBeg, adjPop, random);
                    KllDoublesHelper.mergeSortedDoubleArrays(inBuf, adjBeg, halfAdjPop, inBuf, rawLim, popAbove, inBuf, adjBeg + halfAdjPop);
                }
                currentItemCount -= halfAdjPop;
                inLevels[curLevel + 1] = inLevels[curLevel + 1] - halfAdjPop;
                if (curLevel == numLevels - 1) {
                    targetItemCount += KllHelper.levelCapacity(k, ++numLevels, 0, m);
                }
            }
            if (curLevel != numLevels - 1) continue;
            doneYet = true;
        }
        assert (outLevels[numLevels] - outLevels[0] == currentItemCount);
        return new int[]{numLevels, targetItemCount, currentItemCount};
    }

    private static KllDoublesQuantileCalculator getDoublesQuantileCalculator(KllSketch mine) {
        int[] myLevelsArr = mine.getLevelsArray();
        double[] myDoubleItemsArr = mine.getDoubleItemsArray();
        if (!mine.isLevelZeroSorted()) {
            Arrays.sort(myDoubleItemsArr, myLevelsArr[0], myLevelsArr[1]);
            if (!mine.hasMemory()) {
                mine.setLevelZeroSorted(true);
            }
        }
        return new KllDoublesQuantileCalculator(myDoubleItemsArr, myLevelsArr, mine.getNumLevels(), mine.getN());
    }

    private static void incrementDoublesBucketsSortedLevel(KllSketch mine, int fromIndex, int toIndex, int weight, double[] splitPoints, double[] buckets) {
        double[] myDoubleItemsArr = mine.getDoubleItemsArray();
        int i = fromIndex;
        int j = 0;
        while (i < toIndex && j < splitPoints.length) {
            if (myDoubleItemsArr[i] < splitPoints[j]) {
                int n = j;
                buckets[n] = buckets[n] + (double)weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            buckets[n] = buckets[n] + (double)(weight * (toIndex - i));
        }
    }

    private static void incrementDoublesBucketsUnsortedLevel(KllSketch mine, int fromIndex, int toIndex, int weight, double[] splitPoints, double[] buckets) {
        double[] myDoubleItemsArr = mine.getDoubleItemsArray();
        for (int i = fromIndex; i < toIndex; ++i) {
            int j;
            for (j = 0; j < splitPoints.length && !(myDoubleItemsArr[i] < splitPoints[j]); ++j) {
            }
            int n = j;
            buckets[n] = buckets[n] + (double)weight;
        }
    }

    private static void populateDoubleWorkArrays(double[] workbuf, int[] worklevels, int provisionalNumLevels, int myCurNumLevels, int[] myCurLevelsArr, double[] myCurDoubleItemsArr, int otherNumLevels, int[] otherLevelsArr, double[] otherDoubleItemsArr) {
        worklevels[0] = 0;
        int selfPopZero = KllHelper.currentLevelSize(0, myCurNumLevels, myCurLevelsArr);
        System.arraycopy(myCurDoubleItemsArr, myCurLevelsArr[0], workbuf, worklevels[0], selfPopZero);
        worklevels[1] = worklevels[0] + selfPopZero;
        for (int lvl = 1; lvl < provisionalNumLevels; ++lvl) {
            int selfPop = KllHelper.currentLevelSize(lvl, myCurNumLevels, myCurLevelsArr);
            int otherPop = KllHelper.currentLevelSize(lvl, otherNumLevels, otherLevelsArr);
            worklevels[lvl + 1] = worklevels[lvl] + selfPop + otherPop;
            if (selfPop > 0 && otherPop == 0) {
                System.arraycopy(myCurDoubleItemsArr, myCurLevelsArr[lvl], workbuf, worklevels[lvl], selfPop);
                continue;
            }
            if (selfPop == 0 && otherPop > 0) {
                System.arraycopy(otherDoubleItemsArr, otherLevelsArr[lvl], workbuf, worklevels[lvl], otherPop);
                continue;
            }
            if (selfPop <= 0 || otherPop <= 0) continue;
            KllDoublesHelper.mergeSortedDoubleArrays(myCurDoubleItemsArr, myCurLevelsArr[lvl], selfPop, otherDoubleItemsArr, otherLevelsArr[lvl], otherPop, workbuf, worklevels[lvl]);
        }
    }

    private static double resolveDoubleMaxValue(double myMax, double otherMax) {
        if (Double.isNaN(myMax) && Double.isNaN(otherMax)) {
            return Double.NaN;
        }
        if (Double.isNaN(myMax)) {
            return otherMax;
        }
        if (Double.isNaN(otherMax)) {
            return myMax;
        }
        return Math.max(myMax, otherMax);
    }

    private static double resolveDoubleMinValue(double myMin, double otherMin) {
        if (Double.isNaN(myMin) && Double.isNaN(otherMin)) {
            return Double.NaN;
        }
        if (Double.isNaN(myMin)) {
            return otherMin;
        }
        if (Double.isNaN(otherMin)) {
            return myMin;
        }
        return Math.min(myMin, otherMin);
    }

    private static void validateDoubleValues(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!Double.isFinite(values[i])) {
                throw new SketchesArgumentException("Values must be finite");
            }
            if (i >= values.length - 1 || !(values[i] >= values[i + 1])) continue;
            throw new SketchesArgumentException("Values must be unique and monotonically increasing");
        }
    }
}

