/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MarshallerOptions;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;

final class MarshallerCache {
    private final Map<MarshallerOptions, MarshallerReference> cache = new HashMap<MarshallerOptions, MarshallerReference>();
    private final ReferenceQueue<TypeSpecificMarshaller<?>> queue = new ReferenceQueue();
    private final ReentrantLock lock = new ReentrantLock();

    MarshallerCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    TypeSpecificMarshaller<?> get(MarshallerOptions key) {
        this.lock.lock();
        try {
            this.clean();
            MarshallerReference ref = this.cache.get(key);
            TypeSpecificMarshaller typeSpecificMarshaller = ref != null ? (TypeSpecificMarshaller)ref.get() : null;
            return typeSpecificMarshaller;
        }
        finally {
            this.lock.unlock();
        }
    }

    void put(MarshallerOptions key, TypeSpecificMarshaller<?> value) {
        this.lock.lock();
        try {
            this.clean();
            this.cache.put(key, new MarshallerReference(key, value, this.queue));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clean() {
        MarshallerReference ref;
        while ((ref = (MarshallerReference)this.queue.poll()) != null) {
            this.cache.remove(ref.getKey());
        }
    }

    private static class MarshallerReference
    extends WeakReference<TypeSpecificMarshaller<?>> {
        private final MarshallerOptions key;

        MarshallerReference(MarshallerOptions key, TypeSpecificMarshaller<?> value, ReferenceQueue<TypeSpecificMarshaller<?>> queue) {
            super(value, queue);
            this.key = key;
        }

        MarshallerOptions getKey() {
            return this.key;
        }
    }
}

