/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl.spec.sink;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.AbstractSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.sampler.PossibilitySampler;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.sampler.RateLimitingSampler;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.sampler.Sampler;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class SamplerSpec
extends AbstractSpec {
    private final Map<GString, Sampler> rateLimitSamplers = new ConcurrentHashMap<GString, Sampler>();
    private final Map<Integer, Sampler> possibilitySamplers = new ConcurrentHashMap<Integer, Sampler>();
    private final RateLimitingSampler.ResetHandler rlsResetHandler = new RateLimitingSampler.ResetHandler();

    public SamplerSpec(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig) {
        super(moduleManager, moduleConfig);
    }

    public void rateLimit(GString id, @DelegatesTo(value=RateLimitingSampler.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        Sampler sampler = this.rateLimitSamplers.computeIfAbsent(id, $ -> new RateLimitingSampler(this.rlsResetHandler).start());
        cl.setDelegate((Object)sampler);
        cl.call();
        this.sampleWith(sampler);
    }

    public void possibility(int percentage, @DelegatesTo(value=PossibilitySampler.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        Sampler sampler = this.possibilitySamplers.computeIfAbsent(percentage, $ -> new PossibilitySampler(percentage).start());
        cl.setDelegate((Object)sampler);
        cl.call();
        this.sampleWith(sampler);
    }

    private void sampleWith(Sampler sampler) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        if (sampler.sample()) {
            ((Binding)((Object)BINDING.get())).save();
        } else {
            ((Binding)((Object)BINDING.get())).drop();
        }
    }
}

