/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.base;

import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.InlineMe;
import com.linecorp.armeria.internal.shaded.guava.base.Function;
import com.linecorp.armeria.internal.shaded.guava.base.NullnessCasts;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import javax.annotation.CheckForNull;

public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;

    protected Converter() {
        this(true);
    }

    Converter(boolean handleNullAutomatically) {
        this.handleNullAutomatically = handleNullAutomatically;
    }

    @ForOverride
    protected abstract B doForward(A var1);

    @CheckForNull
    public final B convert(@CheckForNull A a) {
        return this.correctedDoForward(a);
    }

    @CheckForNull
    B correctedDoForward(@CheckForNull A a) {
        if (this.handleNullAutomatically) {
            return a == null ? null : (B)Preconditions.checkNotNull(this.doForward(a));
        }
        return this.unsafeDoForward(a);
    }

    @CheckForNull
    private B unsafeDoForward(@CheckForNull A a) {
        return this.doForward(NullnessCasts.uncheckedCastNullableTToT(a));
    }

    @Override
    @Deprecated
    @InlineMe(replacement="this.convert(a)")
    public final B apply(A a) {
        return this.convert(a);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return super.equals(object);
    }
}

