/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.parser.sample;

import org.apache.skywalking.oap.server.library.util.prometheus.parser.sample.Context;

enum State {
    NAME{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '{') {
                return START_OF_LABEL_NAME;
            }
            if (State.isWhitespace(c)) {
                return END_OF_NAME;
            }
            ctx.name.append(c);
            return this;
        }
    }
    ,
    END_OF_NAME{

        @Override
        State nextState(char c, Context ctx) {
            if (State.isWhitespace(c)) {
                return this;
            }
            if (c == '{') {
                return START_OF_LABEL_NAME;
            }
            ctx.value.append(c);
            return VALUE;
        }
    }
    ,
    START_OF_LABEL_NAME{

        @Override
        State nextState(char c, Context ctx) {
            if (State.isWhitespace(c)) {
                return this;
            }
            if (c == '}') {
                return END_OF_LABELS;
            }
            ctx.labelname.append(c);
            return LABEL_NAME;
        }
    }
    ,
    LABEL_NAME{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '=') {
                return LABEL_VALUE_QUOTE;
            }
            if (c == '}') {
                return END_OF_LABELS;
            }
            if (State.isWhitespace(c)) {
                return LABEL_VALUE_EQUALS;
            }
            ctx.labelname.append(c);
            return this;
        }
    }
    ,
    LABEL_VALUE_EQUALS{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '=') {
                return LABEL_VALUE_QUOTE;
            }
            if (State.isWhitespace(c)) {
                return this;
            }
            return INVALID;
        }
    }
    ,
    LABEL_VALUE_QUOTE{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '\"') {
                return LABEL_VALUE;
            }
            if (State.isWhitespace(c)) {
                return this;
            }
            return INVALID;
        }
    }
    ,
    LABEL_VALUE{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '\\') {
                return LABEL_VALUE_SLASH;
            }
            if (c == '\"') {
                ctx.labels.put(ctx.labelname.toString(), ctx.labelvalue.toString());
                ctx.labelname.setLength(0);
                ctx.labelvalue.setLength(0);
                return NEXT_LABEL;
            }
            ctx.labelvalue.append(c);
            return this;
        }
    }
    ,
    LABEL_VALUE_SLASH{

        @Override
        State nextState(char c, Context ctx) {
            if (c == '\\') {
                ctx.labelvalue.append('\\');
            } else if (c == 'n') {
                ctx.labelvalue.append('\n');
            } else if (c == '\"') {
                ctx.labelvalue.append('\"');
            }
            ctx.labelvalue.append('\\').append(c);
            return LABEL_VALUE;
        }
    }
    ,
    NEXT_LABEL{

        @Override
        State nextState(char c, Context ctx) {
            if (c == ',') {
                return LABEL_NAME;
            }
            if (c == '}') {
                return END_OF_LABELS;
            }
            if (State.isWhitespace(c)) {
                return this;
            }
            return INVALID;
        }
    }
    ,
    END_OF_LABELS{

        @Override
        State nextState(char c, Context ctx) {
            if (State.isWhitespace(c)) {
                return this;
            }
            ctx.value.append(c);
            return VALUE;
        }
    }
    ,
    VALUE{

        @Override
        State nextState(char c, Context ctx) {
            if (State.isWhitespace(c)) {
                return END;
            }
            ctx.value.append(c);
            return this;
        }
    }
    ,
    END{

        @Override
        State nextState(char c, Context ctx) {
            throw new IllegalStateException();
        }
    }
    ,
    INVALID{

        @Override
        State nextState(char c, Context ctx) {
            throw new IllegalStateException();
        }
    };


    abstract State nextState(char var1, Context var2);

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }
}

