/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.tcp.k8s;

import com.google.common.base.Strings;
import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.istio.IstioServiceEntryRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.Addresses;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.AbstractTCPAccessLogAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshTCPAnalysis
extends AbstractTCPAccessLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshTCPAnalysis.class);
    protected K8SServiceRegistry k8sServiceRegistry;
    protected IstioServiceEntryRegistry istioServiceRegistry;
    private EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.k8sServiceRegistry = new K8SServiceRegistry(config);
        this.istioServiceRegistry = new IstioServiceEntryRegistry(config);
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, TCPAccessLogEntry entry, Role role) {
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(previousResult, entry);
            }
            case SIDECAR: {
                if (previousResult.hasResult()) {
                    return previousResult;
                }
                return this.analyzeSideCar(previousResult, entry);
            }
        }
        return previousResult;
    }

    protected AccessLogAnalyzer.Result analyzeSideCar(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        String cluster = properties.getUpstreamCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            return previousResult;
        }
        AccessLogAnalyzer.Result.ResultBuilder newResult = previousResult.toBuilder();
        ServiceMeshMetrics.Builder previousMetrics = previousResult.getMetrics();
        TCPServiceMeshMetrics.Builder sources = previousMetrics.getTcpMetricsBuilder();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(Addresses.getAddressIP(downstreamRemoteAddress));
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        ServiceMetaInfo localService = this.find(Addresses.getAddressIP(downstreamLocalAddress));
        if (cluster.startsWith("inbound|")) {
            TCPServiceMeshMetric metrics;
            if (downstreamService.equals(this.config.serviceMetaInfoFactory().unknown())) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics().build();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics().build();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.addMetrics(metrics);
            newResult.hasDownstreamMetrics(true);
        } else if (cluster.startsWith("outbound|")) {
            ServiceMetaInfo destService = this.find(Addresses.getAddressIP(properties.getUpstreamRemoteAddress()));
            TCPServiceMeshMetric metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics().build();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.addMetrics(metric);
            newResult.hasUpstreamMetrics(true);
        }
        return newResult.metrics(previousMetrics.setTcpMetrics(sources)).service(localService).build();
    }

    protected AccessLogAnalyzer.Result analyzeProxy(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        if (previousResult.hasUpstreamMetrics() && previousResult.hasDownstreamMetrics()) {
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (!(properties.hasDownstreamLocalAddress() && properties.hasDownstreamRemoteAddress() && properties.hasUpstreamRemoteAddress())) {
            return previousResult;
        }
        ServiceMetaInfo ingress = this.find(Addresses.getAddressIP(downstreamLocalAddress));
        AccessLogAnalyzer.Result.ResultBuilder newResult = previousResult.toBuilder();
        ServiceMeshMetrics.Builder previousMetrics = previousResult.getMetrics();
        TCPServiceMeshMetrics.Builder metrics = previousMetrics.getTcpMetricsBuilder();
        if (!previousResult.hasDownstreamMetrics()) {
            ServiceMetaInfo outside = this.find(Addresses.getAddressIP(downstreamRemoteAddress));
            TCPServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
            log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
            metrics.addMetrics(metric);
            newResult.hasDownstreamMetrics(true);
        }
        if (!previousResult.hasUpstreamMetrics()) {
            ServiceMetaInfo targetService = this.find(Addresses.getAddressIP(upstreamRemoteAddress));
            TCPServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics().setTlsMode("NONE");
            log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
            metrics.addMetrics(outboundMetric);
            newResult.hasUpstreamMetrics(true);
        }
        return newResult.metrics(previousMetrics.setTcpMetrics(metrics)).service(ingress).build();
    }

    protected ServiceMetaInfo find(String ip) {
        ServiceMetaInfo istioService = this.istioServiceRegistry.findService(ip);
        if (!Objects.equals(this.config.serviceMetaInfoFactory().unknown(), istioService)) {
            return istioService;
        }
        return this.k8sServiceRegistry.findService(ip);
    }
}

