/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.NullableValue;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsQueryService.class);
    private final ModuleManager moduleManager;
    private IMetricsQueryDAO metricQueryDAO;

    public MetricsQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetricsQueryDAO getMetricQueryDAO() {
        if (this.metricQueryDAO == null) {
            this.metricQueryDAO = (IMetricsQueryDAO)this.moduleManager.find("storage").provider().getService(IMetricsQueryDAO.class);
        }
        return this.metricQueryDAO;
    }

    public NullableValue readMetricsValue(MetricsCondition condition, Duration duration) throws IOException {
        OptionalDouble avgValue;
        long defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        if (!condition.senseScope() || !condition.getEntity().isValid()) {
            return new NullableValue(defaultValue, true);
        }
        MetricsValues metricsValues = this.readMetricsValues(condition, duration);
        if (!metricsValues.getValues().getValues().isEmpty() && (avgValue = metricsValues.getValues().getValues().stream().filter(v -> !v.isEmptyValue()).mapToLong(KVInt::getValue).average()).isPresent()) {
            return new NullableValue((long)avgValue.getAsDouble(), false);
        }
        return new NullableValue(defaultValue, true);
    }

    private MetricsValues invokeReadMetricsValues(MetricsCondition condition, Duration duration) throws IOException {
        if (!condition.senseScope() || !condition.getEntity().isValid()) {
            return new MetricsValues();
        }
        return this.getMetricQueryDAO().readMetricsValuesDebuggable(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsValues readMetricsValues(MetricsCondition condition, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: readMetricsValues");
                span.setMsg("MetricsCondition: " + String.valueOf(condition) + ", Duration: " + String.valueOf(duration));
            }
            MetricsValues metricsValues = this.invokeReadMetricsValues(condition, duration);
            return metricsValues;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private List<MetricsValues> invokeReadLabeledMetricsValues(MetricsCondition condition, List<KeyValue> labels, Duration duration) throws IOException {
        if (!condition.senseScope() || !condition.getEntity().isValid()) {
            return Collections.emptyList();
        }
        return this.getMetricQueryDAO().readLabeledMetricsValuesDebuggable(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), labels, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, List<KeyValue> labels, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: readLabeledMetricsValues");
                span.setMsg("MetricsCondition: " + String.valueOf(condition) + ", Labels: " + String.valueOf(labels) + ", Duration: " + String.valueOf(duration));
            }
            List<MetricsValues> list = this.invokeReadLabeledMetricsValues(condition, labels, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public List<MetricsValues> readLabeledMetricsValuesWithoutEntity(String metricsName, List<KeyValue> labels, Duration duration) throws IOException {
        return this.getMetricQueryDAO().readLabeledMetricsValuesWithoutEntity(metricsName, ValueColumnMetadata.INSTANCE.getValueCName(metricsName), labels, duration);
    }

    public HeatMap readHeatMap(MetricsCondition condition, Duration duration) throws IOException {
        if (!condition.senseScope() || !condition.getEntity().isValid()) {
            return new HeatMap();
        }
        return this.getMetricQueryDAO().readHeatMap(condition, ValueColumnMetadata.INSTANCE.getValueCName(condition.getName()), duration);
    }
}

