/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace.analyze;

import com.google.perftools.profiles.ProfileProto;
import com.google.protobuf.ProtocolStringList;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.input.SegmentProfileAnalyzeQuery;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileStackElement;
import org.apache.skywalking.oap.server.core.query.type.ProfileStackTree;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofParser;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofSegmentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoProfileAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoProfileAnalyzer.class);

    public ProfileAnalyzation analyze(String segmentId, ProfileProto.Profile profile) {
        long periodMs = PprofSegmentParser.resolvePeriodMillis((ProfileProto.Profile)profile);
        HashMap<CallSite, Integer> key2Id = new HashMap<CallSite, Integer>();
        ArrayList<ProfileStackElement> elements = new ArrayList<ProfileStackElement>();
        ProtocolStringList stringTable = profile.getStringTableList();
        for (Object sample : profile.getSampleList()) {
            String seg = PprofSegmentParser.extractSegmentIdFromLabels((List)sample.getLabelList(), (List)stringTable);
            if (seg == null || !seg.equals(segmentId)) continue;
            long sampleCount = sample.getValueCount() > 0 ? sample.getValue(0) : 1L;
            long weightMs = sampleCount * periodMs;
            List stack = PprofSegmentParser.extractStackFromSample((ProfileProto.Sample)sample, (ProfileProto.Profile)profile);
            Collections.reverse(stack);
            int parentId = -1;
            for (String fn : stack) {
                ProfileStackElement element;
                String key = parentId + "|" + fn;
                Integer nodeId = (Integer)key2Id.get(key);
                if (nodeId == null) {
                    element = new ProfileStackElement();
                    element.setId(elements.size());
                    element.setParentId(parentId);
                    element.setCodeSignature(fn);
                    element.setDuration(0);
                    element.setDurationChildExcluded(0);
                    element.setCount(0);
                    elements.add(element);
                    nodeId = element.getId();
                    key2Id.put((CallSite)((Object)key), nodeId);
                }
                element = (ProfileStackElement)elements.get(nodeId);
                element.setDuration(element.getDuration() + (int)weightMs);
                element.setCount(element.getCount() + (int)sampleCount);
                parentId = nodeId;
            }
        }
        int rootCount = 0;
        for (ProfileStackElement e : elements) {
            if (e.getParentId() != -1) continue;
            ++rootCount;
        }
        if (rootCount > 1) {
            int virtualRootId = elements.size();
            Iterator virtualRoot = new ProfileStackElement();
            ((ProfileStackElement)((Object)virtualRoot)).setId(virtualRootId);
            ((ProfileStackElement)((Object)virtualRoot)).setParentId(-1);
            ((ProfileStackElement)((Object)virtualRoot)).setCodeSignature("root");
            ((ProfileStackElement)((Object)virtualRoot)).setDuration(0);
            ((ProfileStackElement)((Object)virtualRoot)).setDurationChildExcluded(0);
            ((ProfileStackElement)((Object)virtualRoot)).setCount(0);
            elements.add((ProfileStackElement)((Object)virtualRoot));
            for (ProfileStackElement e : elements) {
                if (e.getId() == virtualRootId || e.getParentId() != -1) continue;
                e.setParentId(virtualRootId);
                ((ProfileStackElement)((Object)virtualRoot)).setDuration(((ProfileStackElement)((Object)virtualRoot)).getDuration() + e.getDuration());
                ((ProfileStackElement)((Object)virtualRoot)).setCount(((ProfileStackElement)((Object)virtualRoot)).getCount() + e.getCount());
            }
        }
        HashMap<Integer, Integer> childDurSum = new HashMap<Integer, Integer>();
        for (ProfileStackElement child : elements) {
            int pid = child.getParentId();
            if (pid == -1) continue;
            childDurSum.put(pid, childDurSum.getOrDefault(pid, 0) + child.getDuration());
        }
        for (ProfileStackElement elem : elements) {
            int childrenSum = childDurSum.getOrDefault(elem.getId(), 0);
            elem.setDurationChildExcluded(Math.max(0, elem.getDuration() - childrenSum));
        }
        Integer rootId = null;
        for (ProfileStackElement e : elements) {
            if (e.getParentId() != -1) continue;
            rootId = e.getId();
            break;
        }
        if (rootId != null) {
            HashMap<Integer, List> childrenMap = new HashMap<Integer, List>();
            for (ProfileStackElement e : elements) {
                childrenMap.computeIfAbsent(e.getParentId(), k -> new ArrayList()).add(e);
            }
            ArrayList<ProfileStackElement> ordered = new ArrayList<ProfileStackElement>();
            ArrayDeque<ProfileStackElement> queue = new ArrayDeque<ProfileStackElement>();
            for (ProfileStackElement e : elements) {
                if (e.getId() != rootId.intValue()) continue;
                queue.add(e);
                break;
            }
            while (!queue.isEmpty()) {
                ProfileStackElement cur = (ProfileStackElement)queue.removeFirst();
                ordered.add(cur);
                List children = (List)childrenMap.get(cur.getId());
                if (children == null) continue;
                children.sort((a, b) -> Integer.compare(b.getDuration(), a.getDuration()));
                queue.addAll(children);
            }
            HashMap<Integer, Integer> idRemap = new HashMap<Integer, Integer>();
            for (int i = 0; i < ordered.size(); ++i) {
                idRemap.put(((ProfileStackElement)ordered.get(i)).getId(), i);
            }
            for (ProfileStackElement e : ordered) {
                int newId = (Integer)idRemap.get(e.getId());
                int parentId = e.getParentId();
                e.setId(newId);
                if (parentId == -1) {
                    e.setParentId(-1);
                    continue;
                }
                e.setParentId(idRemap.getOrDefault(parentId, -1));
            }
            elements = ordered;
        }
        ProfileStackTree tree = new ProfileStackTree();
        tree.setElements(elements);
        ProfileAnalyzation result = new ProfileAnalyzation();
        result.getTrees().add(tree);
        return result;
    }

    public ProfileAnalyzation analyzeRecords(List<ProfileThreadSnapshotRecord> records, List<SegmentProfileAnalyzeQuery> queries) {
        ProfileAnalyzation result = new ProfileAnalyzation();
        Map<String, SegmentProfileAnalyzeQuery> queryMap = queries.stream().collect(Collectors.toMap(SegmentProfileAnalyzeQuery::getSegmentId, q -> q));
        for (ProfileThreadSnapshotRecord record : records) {
            try {
                SegmentProfileAnalyzeQuery query = queryMap.get(record.getSegmentId());
                if (query == null) {
                    LOGGER.warn("No query found for Go profile segment: {}", (Object)record.getSegmentId());
                    continue;
                }
                ProfileProto.Profile profile = PprofParser.parseProfile((byte[])record.getStackBinary());
                ProfileAnalyzation recordAnalyzation = this.analyze(record.getSegmentId(), profile);
                if (recordAnalyzation == null || recordAnalyzation.getTrees().isEmpty()) continue;
                result.getTrees().addAll(recordAnalyzation.getTrees());
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Go profile analysis completed: segmentId={}, window=[{}-{}], trees={}", new Object[]{record.getSegmentId(), query.getTimeRange().getStart(), query.getTimeRange().getEnd(), recordAnalyzation.getTrees().size()});
            }
            catch (Exception e) {
                LOGGER.error("Failed to analyze Go profile record: segmentId={}, sequence={}, dumpTime={}", new Object[]{record.getSegmentId(), record.getSequence(), record.getDumpTime(), e});
            }
        }
        return result;
    }
}

