/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="jfr_profiling_data", scopeId=84, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="upload_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class JFRProfilingDataRecord
extends Record {
    public static final String INDEX_NAME = "jfr_profiling_data";
    public static final String TASK_ID = "task_id";
    public static final String EVENT_TYPE = "event_type";
    public static final String INSTANCE_ID = "instance_id";
    public static final String DATA_BINARY = "data_binary";
    public static final String UPLOAD_TIME = "upload_time";
    @Column(name="task_id")
    private String taskId;
    @Column(name="instance_id")
    @BanyanDB.SeriesID(index=0)
    private String instanceId;
    @Column(name="event_type")
    private String eventType;
    @Column(name="upload_time")
    private long uploadTime;
    @Column(name="data_binary", storageOnly=true)
    private byte[] dataBinary;

    @Override
    public StorageID id() {
        return new StorageID().append(Hashing.sha256().newHasher().putString((CharSequence)this.taskId, StandardCharsets.UTF_8).putString((CharSequence)this.instanceId, StandardCharsets.UTF_8).putString((CharSequence)this.eventType, StandardCharsets.UTF_8).putLong(this.uploadTime).hash().toString());
    }

    @Generated
    public JFRProfilingDataRecord() {
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public long getUploadTime() {
        return this.uploadTime;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JFRProfilingDataRecord)) {
            return false;
        }
        JFRProfilingDataRecord other = (JFRProfilingDataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        return Arrays.equals(this.getDataBinary(), other.getDataBinary());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JFRProfilingDataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getDataBinary());
        return result;
    }

    @Generated
    public String toString() {
        return "JFRProfilingDataRecord(taskId=" + this.getTaskId() + ", instanceId=" + this.getInstanceId() + ", eventType=" + this.getEventType() + ", uploadTime=" + this.getUploadTime() + ", dataBinary=" + Arrays.toString(this.getDataBinary()) + ")";
    }

    public static class Builder
    implements StorageBuilder<JFRProfilingDataRecord> {
        @Override
        public JFRProfilingDataRecord storage2Entity(Convert2Entity converter) {
            JFRProfilingDataRecord dataTraffic = new JFRProfilingDataRecord();
            dataTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            dataTraffic.setTaskId((String)converter.get(JFRProfilingDataRecord.TASK_ID));
            dataTraffic.setInstanceId((String)converter.get(JFRProfilingDataRecord.INSTANCE_ID));
            dataTraffic.setUploadTime(((Number)converter.get(JFRProfilingDataRecord.UPLOAD_TIME)).longValue());
            dataTraffic.setEventType((String)converter.get(JFRProfilingDataRecord.EVENT_TYPE));
            dataTraffic.setDataBinary(converter.getBytes(JFRProfilingDataRecord.DATA_BINARY));
            return dataTraffic;
        }

        @Override
        public void entity2Storage(JFRProfilingDataRecord storageData, Convert2Storage converter) {
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(JFRProfilingDataRecord.TASK_ID, storageData.getTaskId());
            converter.accept(JFRProfilingDataRecord.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(JFRProfilingDataRecord.UPLOAD_TIME, storageData.getUploadTime());
            converter.accept(JFRProfilingDataRecord.EVENT_TYPE, storageData.getEventType());
            converter.accept(JFRProfilingDataRecord.DATA_BINARY, storageData.getDataBinary());
        }
    }
}

