/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.management.ui.template;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplateManagementService;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITemplateInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UITemplateInitializer.class);
    public static String[] UI_TEMPLATE_FOLDER = new String[]{Layer.MESH.name(), Layer.GENERAL.name(), Layer.OS_LINUX.name(), Layer.MESH_CP.name(), Layer.MESH_DP.name(), Layer.MYSQL.name(), Layer.POSTGRESQL.name(), Layer.K8S.name(), Layer.BROWSER.name(), Layer.SO11Y_OAP.name(), Layer.VIRTUAL_DATABASE.name(), Layer.VIRTUAL_CACHE.name(), Layer.K8S_SERVICE.name(), Layer.SO11Y_SATELLITE.name(), Layer.APISIX.name(), Layer.VIRTUAL_MQ.name(), Layer.AWS_EKS.name(), Layer.OS_WINDOWS.name(), Layer.AWS_S3.name(), Layer.AWS_DYNAMODB.name(), Layer.AWS_GATEWAY.name(), Layer.REDIS.name(), Layer.ELASTICSEARCH.name(), Layer.RABBITMQ.name(), Layer.MONGODB.name(), Layer.KAFKA.name(), Layer.PULSAR.name(), Layer.BOOKKEEPER.name(), Layer.NGINX.name(), Layer.ROCKETMQ.name(), Layer.CLICKHOUSE.name(), Layer.ACTIVEMQ.name(), Layer.CILIUM_SERVICE.name(), Layer.SO11Y_JAVA_AGENT.name(), Layer.KONG.name(), Layer.SO11Y_GO_AGENT.name(), Layer.FLINK.name(), Layer.BANYANDB.name(), "custom"};
    private final UITemplateManagementService uiTemplateManagementService;
    private final ObjectMapper mapper;

    public UITemplateInitializer(ModuleManager manager) {
        this.uiTemplateManagementService = (UITemplateManagementService)manager.find("core").provider().getService(UITemplateManagementService.class);
        this.mapper = new ObjectMapper();
        this.mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
    }

    public void initAll() throws IOException {
        for (String folder : UI_TEMPLATE_FOLDER) {
            try {
                File[] templateFiles;
                for (File file : templateFiles = ResourceUtils.getPathFiles((String)("ui-initialized-templates/" + folder.toLowerCase()))) {
                    this.initTemplate(file);
                }
            }
            catch (FileNotFoundException e) {
                log.debug("No such folder of path: {}, skipping loading UI templates", (Object)folder);
            }
        }
    }

    public void initTemplate(File template) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(template);
        if (jsonNode == null || jsonNode.size() == 0) {
            return;
        }
        if (jsonNode.size() > 1) {
            throw new IllegalArgumentException("File:  " + template.getName() + " should be only one dashboard setting json object.");
        }
        JsonNode configNode = jsonNode.get(0).get("configuration");
        String inId = jsonNode.get(0).get("id").textValue();
        String inNameKey = StringUtil.join((char)'_', (String[])new String[]{configNode.get("layer").textValue(), configNode.get("entity").textValue(), configNode.get("name").textValue()});
        this.verifyNameConflict(template, inId, inNameKey);
        DashboardSetting setting = new DashboardSetting();
        setting.setId(inId);
        setting.setConfiguration(configNode.toString());
        this.uiTemplateManagementService.addIfNotExist(setting);
    }

    private void verifyNameConflict(File template, String inId, String inNameKey) throws IOException {
        List<DashboardConfiguration> configurations = this.uiTemplateManagementService.getAllTemplates(false);
        for (DashboardConfiguration config : configurations) {
            JsonNode configNode = this.mapper.readTree(config.getConfiguration());
            String id = config.getId();
            String nameKey = StringUtil.join((char)'_', (String[])new String[]{configNode.get("layer").textValue(), configNode.get("entity").textValue(), configNode.get("name").textValue()});
            if (!Objects.equals(nameKey, inNameKey) || id.equals(inId)) continue;
            throw new IllegalArgumentException("File:  " + template.getName() + " layer_entity_name: " + inNameKey + " conflict with exist configuration id: " + id);
        }
    }
}

