/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixResponse;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixResponseJsonSerializer;

public class ZabbixProtocolEncoder
extends MessageToMessageEncoder<ZabbixResponse> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(ZabbixResponse.class, (Object)new ZabbixResponseJsonSerializer()).create();

    protected void encode(ChannelHandlerContext channelHandlerContext, ZabbixResponse zabbixResponse, List<Object> list) throws Exception {
        String responsePayload = this.gson.toJson((Object)zabbixResponse);
        int payloadLength = responsePayload.length();
        byte[] header = new byte[]{90, 66, 88, 68, 1, (byte)(payloadLength & 0xFF), (byte)(payloadLength >> 8 & 0xFF), (byte)(payloadLength >> 16 & 0xFF), (byte)(payloadLength >> 24 & 0xFF), 0, 0, 0, 0};
        ByteBuf buffer = channelHandlerContext.alloc().buffer(header.length + payloadLength);
        buffer.writeBytes(header);
        buffer.writeBytes(responsePayload.getBytes(Charsets.UTF_8));
        buffer.retain();
        channelHandlerContext.writeAndFlush((Object)buffer);
    }
}

