/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.provider;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.SignUtils;
import org.apache.shenyu.plugin.sign.api.SignParameters;
import org.apache.shenyu.plugin.sign.provider.SignProvider;
import org.springframework.web.util.UriComponentsBuilder;

public class VersionOneSignProvider
implements SignProvider {
    @Override
    public String generateSign(String signKey, SignParameters signParameters, String requestBody) {
        return this.sign(signKey, signParameters, requestBody);
    }

    @Override
    public String generateSign(String signKey, SignParameters signParameters) {
        return this.sign(signKey, signParameters, null);
    }

    private String sign(String signKey, SignParameters signParameters, String requestBody) {
        Map<String, String> params = this.getParams(signParameters, requestBody);
        String data = params.keySet().stream().sorted(Comparator.naturalOrder()).filter(key -> !Objects.equals(key, "sign")).map(key -> String.join((CharSequence)"", key, (CharSequence)params.get(key))).collect(Collectors.joining()).trim();
        return SignUtils.sign((String)signParameters.getSignAlg(), (String)signKey, (String)data).toUpperCase();
    }

    private Map<String, String> getParams(SignParameters signParameters, String requestBody) {
        HashMap params = Maps.newHashMap();
        params.put("timestamp", signParameters.getTimestamp());
        params.put("path", signParameters.getUri().getRawPath());
        params.put("version", signParameters.getVersion());
        if (Objects.isNull(requestBody)) {
            return params;
        }
        if (!StringUtils.isEmpty((CharSequence)requestBody)) {
            JsonUtils.jsonToMap((String)requestBody).forEach((k, v) -> params.putIfAbsent(k, Objects.toString(v, null)));
        }
        Map queryParams = UriComponentsBuilder.fromUri((URI)signParameters.getUri()).build().getQueryParams().toSingleValueMap();
        params.putAll(queryParams);
        return params;
    }
}

