/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Config {
    private static final String TAG_STARTER = "<";
    private static final String TAG_OVER = "</";
    private static final String TAG_ENDER = "/>";
    private static final String TAG_CLOSE = ">";
    private static final String ATTR_FLAGF = "=";
    private static final String COMMENT = "#";
    private final HashMap<String, List<String>> subTags = new HashMap();
    private final HashMap<String, List<String>> subKeys = new HashMap();
    private final HashMap<String, String> values = new HashMap();
    private final HashMap<String, String> escapedValues = new HashMap();

    private Config(String[] lines) {
        LinkedList<String> stack = new LinkedList<String>();
        stack.addLast("");
        this.subTags.put("", new ArrayList());
        this.subKeys.put("", new ArrayList());
        for (int i = 0; i < lines.length; ++i) {
            String value;
            String key;
            String path;
            String name;
            String line = lines[i].trim();
            if (line.length() <= 0 || line.startsWith(COMMENT)) continue;
            if (line.startsWith(TAG_OVER) && line.endsWith(TAG_CLOSE)) {
                name = line.substring(TAG_OVER.length(), line.length() - TAG_CLOSE.length());
                path = (String)stack.getLast();
                if (!path.endsWith("/" + name)) {
                    throw new RuntimeException("Invalid tag end : " + name + " at line no " + i);
                }
                stack.removeLast();
                continue;
            }
            if (line.startsWith(TAG_STARTER) && line.endsWith(TAG_ENDER)) {
                name = line.substring(TAG_STARTER.length(), line.length() - TAG_ENDER.length());
                path = (String)stack.getLast();
                String newPath = path + "/" + name;
                this.subTags.get(path).add(name);
                if (!this.subTags.containsKey(newPath)) {
                    this.subTags.put(newPath, new ArrayList());
                }
                if (this.subKeys.containsKey(newPath)) continue;
                this.subKeys.put(newPath, new ArrayList());
                continue;
            }
            if (line.startsWith(TAG_STARTER) && line.endsWith(TAG_CLOSE)) {
                name = line.substring(TAG_STARTER.length(), line.length() - TAG_CLOSE.length());
                path = (String)stack.getLast();
                String newPath = path + "/" + name;
                this.subTags.get(path).add(name);
                if (!this.subTags.containsKey(newPath)) {
                    this.subTags.put(newPath, new ArrayList());
                }
                if (!this.subKeys.containsKey(newPath)) {
                    this.subKeys.put(newPath, new ArrayList());
                }
                stack.addLast(newPath);
                continue;
            }
            if (line.startsWith(TAG_STARTER) || line.endsWith(TAG_CLOSE)) {
                throw new RuntimeException("Invalid line : " + line + " at line no " + i);
            }
            int idx = line.indexOf(ATTR_FLAGF);
            if (idx < 0) {
                key = line.trim();
                value = "";
            } else {
                key = line.substring(0, idx).trim();
                value = line.substring(idx + ATTR_FLAGF.length()).trim();
            }
            String path2 = (String)stack.getLast();
            String newPath = path2 + TAG_STARTER + key + TAG_CLOSE;
            this.subKeys.get(path2).add(key);
            this.values.put(newPath, value);
            this.escapedValues.put(newPath, this.unEscape(value));
        }
    }

    private String unEscape(String value) {
        return value.replaceAll("&amp;", "&").replaceAll("&nbsp;", " ").replaceAll("&lt;", TAG_STARTER).replaceAll("&gt;", TAG_CLOSE).replaceAll("&quot;", "\"");
    }

    public String get(String path, boolean escape) {
        return escape ? this.escapedValues.get(path) : this.values.get(path);
    }

    public String get(String path) {
        return this.get(path, false);
    }

    public String get(String path, String defaultValue) {
        String value = this.get(path, false);
        return value == null ? defaultValue : value;
    }

    public int getInt(String path, int defaultValue) {
        String str = this.get(path);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBool(String path, boolean defaultValue) {
        String str = this.get(path);
        if (str == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(str);
    }

    public List<String> getSubTags(String path) {
        return this.subTags.get(path);
    }

    public List<String> getSubKeys(String path) {
        return this.subKeys.get(path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "", "");
        return sb.toString();
    }

    private void toString(StringBuilder sb, String indent, String path) {
        for (String key : this.subKeys.get(path)) {
            String value = this.values.get(path + TAG_STARTER + key + TAG_CLOSE);
            sb.append(indent).append(key).append(ATTR_FLAGF).append(value).append("\n");
        }
        for (String name : this.subTags.get(path)) {
            String newPath = path + "/" + name;
            List<String> subTags = this.subTags.get(newPath);
            List<String> subKeys = this.subKeys.get(newPath);
            if (subTags.isEmpty() && subKeys.isEmpty()) {
                sb.append(indent).append(TAG_STARTER).append(name).append(TAG_ENDER).append("\n");
                continue;
            }
            sb.append(indent).append(TAG_STARTER).append(name).append(TAG_CLOSE).append("\n");
            this.toString(sb, indent + "  ", newPath);
            sb.append(indent).append(TAG_OVER).append(name).append(TAG_CLOSE).append("\n");
        }
    }

    public static Config parse(String content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return new Config(content.split("\n"));
    }

    public static Config parse(Reader in) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader br = new BufferedReader(in);
        String line = null;
        while ((line = br.readLine()) != null) {
            lineList.add(line);
        }
        return new Config(lineList.toArray(new String[lineList.size()]));
    }

    public static Config parse(InputStream in) throws IOException {
        return Config.parse(new InputStreamReader(in));
    }

    public static Config parse(InputStream in, Charset charset) throws IOException {
        return Config.parse(new InputStreamReader(in, charset));
    }

    public static Config parseFile(String file, Charset charset) throws FileNotFoundException, IOException {
        return Config.parse(new FileInputStream(file), charset);
    }

    public static Config parseFile(String file) throws FileNotFoundException, IOException {
        return Config.parse(new FileInputStream(file));
    }
}

