/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.request;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.RequestHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.UniqueHeaderEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.request.handler.RequestPluginHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RequestPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        RequestHandle requestHandle = (RequestHandle)RequestPluginHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(requestHandle)) {
            LOG.error("request handler can not configuration\uff1a{}", (Object)requestHandle);
            return chain.execute(exchange);
        }
        exchange.getAttributes().put("preserveHost", requestHandle.getPreserveHost());
        if (Objects.nonNull(requestHandle.getRequestHeaderUniqueStrategy()) && StringUtils.isNotEmpty((CharSequence)requestHandle.getRequestUniqueHeaders())) {
            exchange.getAttributes().put(UniqueHeaderEnum.REQ_UNIQUE_HEADER.getStrategy(), requestHandle.getRequestHeaderUniqueStrategy());
            exchange.getAttributes().put(UniqueHeaderEnum.REQ_UNIQUE_HEADER.getName(), requestHandle.getRequestUniqueHeaders());
        }
        if (Objects.nonNull(requestHandle.getRequestHeaderUniqueStrategy()) && StringUtils.isNotEmpty((CharSequence)requestHandle.getRespUniqueHeaders())) {
            exchange.getAttributes().put(UniqueHeaderEnum.RESP_UNIQUE_HEADER.getStrategy(), requestHandle.getRespHeaderUniqueStrategy());
            exchange.getAttributes().put(UniqueHeaderEnum.RESP_UNIQUE_HEADER.getName(), requestHandle.getRespUniqueHeaders());
        }
        if (requestHandle.isEmptyConfig()) {
            LOG.warn("request handler configuration is empty\uff1a{}", (Object)requestHandle);
            return chain.execute(exchange);
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerWebExchange modifiedExchange = exchange.mutate().request(originalRequest -> originalRequest.uri(UriComponentsBuilder.fromUri((URI)exchange.getRequest().getURI()).replaceQueryParams(this.getQueryParams(request, requestHandle)).build().encode().toUri()).headers(httpHeaders -> this.setHeaders((HttpHeaders)httpHeaders, request, requestHandle))).build();
        return chain.execute(modifiedExchange);
    }

    public int getOrder() {
        return PluginEnum.REQUEST.getCode();
    }

    public String named() {
        return PluginEnum.REQUEST.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }

    private void setHeaders(HttpHeaders headers, ServerHttpRequest request, RequestHandle requestHandle) {
        RequestHandle.ShenyuRequestHeader shenyuReqHeader;
        List cookies = this.getCookies(request, requestHandle).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        headers.remove((Object)"Cookie");
        if (CollectionUtils.isNotEmpty(cookies)) {
            headers.set("Cookie", StringUtils.join(cookies, (String)"; "));
        }
        if (Objects.isNull(shenyuReqHeader = requestHandle.getHeader())) {
            return;
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqHeader.getAddHeaders())) {
            shenyuReqHeader.getAddHeaders().entrySet().forEach(s -> this.fillHeader((Map.Entry<String, String>)s, headers));
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqHeader.getSetHeaders())) {
            shenyuReqHeader.getSetHeaders().entrySet().forEach(s -> this.fillHeader((Map.Entry<String, String>)s, headers));
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqHeader.getReplaceHeaderKeys())) {
            shenyuReqHeader.getReplaceHeaderKeys().entrySet().forEach(s -> this.replaceHeaderKey((Map.Entry<String, String>)s, headers));
        }
        if (CollectionUtils.isNotEmpty((Collection)shenyuReqHeader.getRemoveHeaderKeys())) {
            shenyuReqHeader.getRemoveHeaderKeys().forEach(arg_0 -> ((HttpHeaders)headers).remove(arg_0));
        }
    }

    private MultiValueMap<String, HttpCookie> getCookies(ServerHttpRequest request, RequestHandle requestHandle) {
        RequestHandle.ShenyuCookie shenyuCookie = requestHandle.getCookie();
        LinkedMultiValueMap cookies = new LinkedMultiValueMap((Map)request.getCookies());
        if (Objects.isNull(shenyuCookie)) {
            return cookies;
        }
        if (MapUtils.isNotEmpty((Map)shenyuCookie.getAddCookies())) {
            shenyuCookie.getAddCookies().entrySet().forEach(arg_0 -> this.lambda$getCookies$5((MultiValueMap)cookies, arg_0));
        }
        if (MapUtils.isNotEmpty((Map)shenyuCookie.getSetCookies())) {
            shenyuCookie.getSetCookies().entrySet().forEach(arg_0 -> this.lambda$getCookies$6((MultiValueMap)cookies, arg_0));
        }
        if (MapUtils.isNotEmpty((Map)shenyuCookie.getReplaceCookieKeys())) {
            shenyuCookie.getReplaceCookieKeys().entrySet().forEach(arg_0 -> this.lambda$getCookies$7((MultiValueMap)cookies, arg_0));
        }
        if (CollectionUtils.isNotEmpty((Collection)shenyuCookie.getRemoveCookieKeys())) {
            shenyuCookie.getRemoveCookieKeys().forEach(arg_0 -> ((MultiValueMap)cookies).remove(arg_0));
        }
        return cookies;
    }

    private MultiValueMap<String, String> getQueryParams(ServerHttpRequest request, RequestHandle requestHandle) {
        RequestHandle.ShenyuRequestParameter shenyuReqParameter = requestHandle.getParameter();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap((Map)request.getQueryParams());
        if (Objects.isNull(shenyuReqParameter)) {
            return queryParams;
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqParameter.getAddParameters())) {
            shenyuReqParameter.getAddParameters().entrySet().forEach(arg_0 -> this.lambda$getQueryParams$8((MultiValueMap)queryParams, arg_0));
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqParameter.getSetParameters())) {
            shenyuReqParameter.getSetParameters().entrySet().forEach(arg_0 -> this.lambda$getQueryParams$9((MultiValueMap)queryParams, arg_0));
        }
        if (MapUtils.isNotEmpty((Map)shenyuReqParameter.getReplaceParameterKeys())) {
            shenyuReqParameter.getReplaceParameterKeys().entrySet().forEach(arg_0 -> this.lambda$getQueryParams$10((MultiValueMap)queryParams, arg_0));
        }
        if (CollectionUtils.isNotEmpty((Collection)shenyuReqParameter.getRemoveParameterKeys())) {
            shenyuReqParameter.getRemoveParameterKeys().forEach(arg_0 -> ((MultiValueMap)queryParams).remove(arg_0));
        }
        return queryParams;
    }

    private void replaceParameterKey(Map.Entry<String, String> shenyuParam, MultiValueMap<String, String> queryParams) {
        List values = (List)queryParams.get((Object)shenyuParam.getKey());
        if (Objects.nonNull(values)) {
            queryParams.addAll((Object)shenyuParam.getValue(), values);
            queryParams.remove((Object)shenyuParam.getKey());
        }
    }

    private void fillParameter(Map.Entry<String, String> shenyuParam, MultiValueMap<String, String> queryParams) {
        queryParams.set((Object)shenyuParam.getKey(), (Object)shenyuParam.getValue());
    }

    private void replaceCookieKey(Map.Entry<String, String> shenyuCookie, MultiValueMap<String, HttpCookie> cookies) {
        List httpCookies = (List)cookies.get((Object)shenyuCookie.getKey());
        if (Objects.nonNull(httpCookies)) {
            cookies.remove((Object)shenyuCookie.getKey());
            List newKeyCookieList = httpCookies.stream().filter(Objects::nonNull).map(cookie -> new HttpCookie((String)shenyuCookie.getValue(), cookie.getValue())).collect(Collectors.toList());
            cookies.addAll((Object)shenyuCookie.getValue(), newKeyCookieList);
        }
    }

    private void fillCookie(Map.Entry<String, String> shenyuCookie, MultiValueMap<String, HttpCookie> cookies) {
        cookies.set((Object)shenyuCookie.getKey(), (Object)new HttpCookie(shenyuCookie.getKey(), shenyuCookie.getValue()));
    }

    private void replaceHeaderKey(Map.Entry<String, String> shenyuHeader, HttpHeaders headers) {
        List values = headers.get((Object)shenyuHeader.getKey());
        if (Objects.nonNull(values)) {
            headers.addAll(shenyuHeader.getValue(), values);
            headers.remove((Object)shenyuHeader.getKey());
        }
    }

    private void fillHeader(Map.Entry<String, String> shenyuHeader, HttpHeaders headers) {
        headers.set(shenyuHeader.getKey(), shenyuHeader.getValue());
    }

    private /* synthetic */ void lambda$getQueryParams$10(MultiValueMap queryParams, Map.Entry s) {
        this.replaceParameterKey(s, (MultiValueMap<String, String>)queryParams);
    }

    private /* synthetic */ void lambda$getQueryParams$9(MultiValueMap queryParams, Map.Entry s) {
        this.fillParameter(s, (MultiValueMap<String, String>)queryParams);
    }

    private /* synthetic */ void lambda$getQueryParams$8(MultiValueMap queryParams, Map.Entry s) {
        this.fillParameter(s, (MultiValueMap<String, String>)queryParams);
    }

    private /* synthetic */ void lambda$getCookies$7(MultiValueMap cookies, Map.Entry s) {
        this.replaceCookieKey(s, (MultiValueMap<String, HttpCookie>)cookies);
    }

    private /* synthetic */ void lambda$getCookies$6(MultiValueMap cookies, Map.Entry s) {
        this.fillCookie(s, (MultiValueMap<String, HttpCookie>)cookies);
    }

    private /* synthetic */ void lambda$getCookies$5(MultiValueMap cookies, Map.Entry s) {
        this.fillCookie(s, (MultiValueMap<String, HttpCookie>)cookies);
    }
}

