/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.RedactedSupplier;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Supplier;

public class RedactedValueConverter<T>
implements Converter<T, Object> {
    private final Converter<T, Object> delegate;

    public RedactedValueConverter(Converter<T, Object> delegate) {
        this.delegate = (Converter)Assert.notNull(delegate, (String)"Delegate cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        RedactedSupplier<Object> value = this.delegate.applyTo(t);
        if (value != null && !(value instanceof RedactedSupplier)) {
            value = new RedactedSupplier<Object>(value);
        }
        return value;
    }

    @Override
    public T applyFrom(Object o) {
        if (o instanceof RedactedSupplier) {
            o = ((Supplier)o).get();
        }
        return this.delegate.applyFrom(o);
    }
}

