/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.core.GenericHandler;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.core.GenericTransformer;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class LambdaMessageProcessor
implements MessageProcessor<Object>,
BeanFactoryAware {
    private static final Log LOGGER = LogFactory.getLog(LambdaMessageProcessor.class);
    private final Object target;
    private final Method method;
    @Nullable
    private final Class<?> expectedType;
    private final Class<?>[] parameterTypes;
    private MessageConverter messageConverter;

    public LambdaMessageProcessor(Object target, @Nullable Class<?> expectedType) {
        Assert.notNull((Object)target, (String)"'target' must not be null");
        this.target = target;
        Set methods = MethodIntrospector.selectMethods(target.getClass(), methodCandidate -> methodCandidate.getDeclaringClass() != Object.class && !methodCandidate.getDeclaringClass().getName().equals("kotlin.jvm.internal.Lambda") && !methodCandidate.isDefault() && !Modifier.isStatic(methodCandidate.getModifiers()));
        Assert.state((methods.size() == 1 ? 1 : 0) != 0, (String)"LambdaMessageProcessor is applicable for inline or lambda classes with single method - functional interface implementations.");
        this.method = (Method)methods.iterator().next();
        if (!LambdaMessageProcessor.isExplicit(target)) {
            ReflectionUtils.makeAccessible((Method)this.method);
        }
        this.parameterTypes = this.method.getParameterTypes();
        this.expectedType = expectedType;
    }

    private static boolean isExplicit(Object target) {
        return target instanceof Consumer || target instanceof Function || target instanceof GenericHandler || target instanceof GenericSelector || target instanceof GenericTransformer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.messageConverter = (MessageConverter)beanFactory.getBean("integrationArgumentResolverMessageConverter", MessageConverter.class);
    }

    @Override
    public Object processMessage(Message<?> message) {
        Object[] args = this.buildArgs(message);
        try {
            Object result = this.invokeMethod(args);
            if (result != null && org.springframework.integration.util.ClassUtils.isKotlinUnit(result.getClass())) {
                result = null;
            }
            return result;
        }
        catch (ClassCastException ex) {
            this.logClassCastException(ex);
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwable throwable = e.getTargetException();
            if (throwable instanceof ClassCastException) {
                ClassCastException classCastException = (ClassCastException)throwable;
                this.logClassCastException(classCastException);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Could not invoke the method '" + this.method + "'", cause);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException("error occurred during processing message in 'LambdaMessageProcessor' for method [" + this.method + "]", ex);
        }
    }

    private Object[] buildArgs(Message<?> message) {
        Object[] args = new Object[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class<?> parameterType = this.parameterTypes[i];
            if (Message.class.isAssignableFrom(parameterType)) {
                args[i] = message;
                continue;
            }
            if (Map.class.isAssignableFrom(parameterType)) {
                if (message.getPayload() instanceof Map && this.parameterTypes.length == 1) {
                    args[i] = message.getPayload();
                    continue;
                }
                args[i] = message.getHeaders();
                continue;
            }
            if (this.expectedType != null && !ClassUtils.isAssignable(this.expectedType, message.getPayload().getClass())) {
                if (Message.class.isAssignableFrom(this.expectedType)) {
                    args[i] = message;
                    continue;
                }
                Object payload = this.messageConverter.fromMessage(message, this.expectedType);
                if (payload == null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)LogMessage.format((String)"The '%s' returned 'null' for the payload conversion from the '%s' and expected type '%s'.", (Object)this.messageConverter, message, this.expectedType));
                }
                args[i] = payload;
                continue;
            }
            args[i] = message.getPayload();
        }
        return args;
    }

    private Object invokeMethod(Object[] args) throws InvocationTargetException, IllegalAccessException {
        Object object = this.target;
        if (object instanceof Consumer) {
            Consumer consumer = (Consumer)object;
            consumer.accept(args[0]);
            return null;
        }
        object = this.target;
        if (object instanceof Function) {
            Function function2 = (Function)object;
            return function2.apply(args[0]);
        }
        object = this.target;
        if (object instanceof GenericSelector) {
            GenericSelector selector = (GenericSelector)object;
            return selector.accept(args[0]);
        }
        object = this.target;
        if (object instanceof GenericTransformer) {
            GenericTransformer transformer2 = (GenericTransformer)object;
            return transformer2.transform(args[0]);
        }
        object = this.target;
        if (object instanceof GenericHandler) {
            GenericHandler handler = (GenericHandler)object;
            return handler.handle(args[0], (MessageHeaders)args[1]);
        }
        return this.method.invoke(this.target, args);
    }

    private void logClassCastException(ClassCastException classCastException) {
        LOGGER.error((Object)("Could not invoke the method '" + this.method + "' due to a class cast exception, if using a lambda in the DSL, consider using an overloaded EIP method that takes a Class<?> argument to explicitly  specify the type. An example of when this often occurs is if the lambda is configured to receive a Message<?> argument."), (Throwable)classCastException);
    }
}

