/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.exception;

import jakarta.validation.ConstraintViolationException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.exception.WebI18nException;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ResponseBody
@ControllerAdvice
public class ExceptionHandlers {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlers.class);
    private final MessageSource messageSource;

    public ExceptionHandlers(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ShenyuAdminResult handleDuplicateKeyException(DuplicateKeyException exception) {
        LOG.error("duplicate key exception ", (Throwable)exception);
        return ShenyuAdminResult.error("unique index conflict, please enter again");
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    protected ShenyuAdminResult handleUnauthorizedException(UnauthorizedException exception) {
        LOG.error("unauthorized exception", (Throwable)exception);
        return ShenyuAdminResult.error(601, "token has no permission");
    }

    @ExceptionHandler(value={NullPointerException.class})
    protected ShenyuAdminResult handleNullPointException(NullPointerException exception) {
        LOG.error("null pointer exception ", (Throwable)exception);
        return ShenyuAdminResult.error(404, "not found exception");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    protected ShenyuAdminResult handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        LOG.warn("http request method not supported", (Throwable)e);
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMethod());
        sb.append(" method is not supported for this request. Supported methods are ");
        Objects.requireNonNull(e.getSupportedHttpMethods()).forEach(t -> sb.append(t).append(" "));
        return ShenyuAdminResult.error(sb.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ShenyuAdminResult handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        LOG.warn("method argument not valid", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        String errorMsg = bindingResult.getFieldErrors().stream().map(f -> f.getField().concat(": ").concat(Optional.ofNullable(f.getDefaultMessage()).orElse(""))).collect(Collectors.joining("| "));
        return ShenyuAdminResult.error(String.format("Request error! invalid argument [%s]", errorMsg));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    protected ShenyuAdminResult handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        LOG.warn("missing servlet request parameter", (Throwable)e);
        return ShenyuAdminResult.error(String.format("%s parameter is missing", e.getParameterName()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ShenyuAdminResult handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e) {
        LOG.warn("method argument type mismatch", (Throwable)e);
        return ShenyuAdminResult.error(String.format("%s should be of type %s", e.getName(), Objects.requireNonNull(e.getRequiredType()).getName()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ShenyuAdminResult handleConstraintViolationException(ConstraintViolationException e) {
        LOG.warn("constraint violation exception", (Throwable)e);
        Set violations = e.getConstraintViolations();
        return ShenyuAdminResult.error(violations.stream().map(v -> v.getPropertyPath().toString().concat(": ").concat(v.getMessage())).collect(Collectors.joining("| ")));
    }

    @ExceptionHandler(value={ShenyuException.class})
    protected ShenyuAdminResult handleShenyuException(ShenyuException exception) {
        String message;
        LOG.error(exception.getMessage(), (Throwable)exception);
        String string = message = Objects.isNull(exception.getCause()) ? null : exception.getCause().getMessage();
        if (!StringUtils.hasText((String)message)) {
            message = exception.getMessage();
        }
        return ShenyuAdminResult.error(message);
    }

    @ExceptionHandler(value={Exception.class})
    protected ShenyuAdminResult handleExceptionHandler(Exception exception) {
        LOG.error(exception.getMessage(), (Throwable)exception);
        String message = "The system is busy, please try again later";
        return ShenyuAdminResult.error(message);
    }

    @ExceptionHandler(value={WebI18nException.class})
    protected ShenyuAdminResult webI18nException(WebI18nException exception) {
        String message = this.messageSource.getMessage(exception.getMessage(), exception.getArgs(), LocaleContextHolder.getLocale());
        return ShenyuAdminResult.error(500, message);
    }
}

