/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.impl.InvocationContextAccessItem;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class TraceIdAccessItem
extends InvocationContextAccessItem {
    public static final String TRACE_ID = "X-B3-TraceId";

    public TraceIdAccessItem() {
        super(TRACE_ID);
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        String traceId = this.getValueFromInvocationContext(accessLogEvent);
        if (StringUtils.isEmpty((CharSequence)traceId)) {
            traceId = accessLogEvent.getRoutingContext().request().getHeader(TRACE_ID);
        }
        builder.append(StringUtils.isEmpty((CharSequence)traceId) ? "-" : traceId);
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        Invocation invocation = finishEvent.getInvocation();
        if (invocation == null || invocation.getContext() == null || StringUtils.isEmpty((CharSequence)((CharSequence)invocation.getContext().get(TRACE_ID)))) {
            builder.append("-");
            return;
        }
        builder.append((String)invocation.getContext().get(TRACE_ID));
    }
}

