/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.impl.floats;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.Arrays;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.AbstractPrimitiveReaders;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.PrimitiveArrayBuilderWrapper;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.RepeatedReadSchemas;

public class FloatRepeatedReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<float[], Float> readers) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (float[].class.equals((Object)javaType.getRawClass())) {
            return new FloatPrimitiveArraySchema(protoField, propertyDescriptor, readers);
        }
        return RepeatedReadSchemas.create(protoField, propertyDescriptor, readers);
    }

    static class FloatPrimitiveArraySchema<T>
    extends FieldSchema<T> {
        private final Getter<T, float[]> getter;
        private final Setter<T, float[]> setter;
        private final AbstractPrimitiveReaders<float[], Float> readers;

        public FloatPrimitiveArraySchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<float[], Float> readers) {
            super(protoField, propertyDescriptor.getJavaType());
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
            this.readers = readers;
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            PrimitiveArrayBuilderWrapper builderWrapper = new PrimitiveArrayBuilderWrapper(input.getArrayBuilders().getFloatBuilder());
            int fieldNumber = this.readers.primitiveArrayReader.read(input, builderWrapper);
            float[] newValue = (float[])builderWrapper.getArray();
            newValue = this.mergeArray((float[])this.getter.get(message), newValue);
            this.setter.set(message, (Object)newValue);
            return fieldNumber;
        }

        public float[] mergeArray(float[] oldValue, float[] newValue) {
            if (oldValue == null || oldValue.length == 0) {
                return newValue;
            }
            return this.concatArray(oldValue, newValue);
        }

        private float[] concatArray(float[] oldValue, float[] newValue) {
            int len1 = oldValue.length;
            int len2 = newValue.length;
            float[] result = Arrays.copyOf(oldValue, len1 + len2);
            System.arraycopy(newValue, 0, result, len1, len2);
            return result;
        }
    }
}

