/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.handler.governance.InstanceIsolatedEvent;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceIsolationDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceIsolationDiscoveryFilter.class);
    private static final String KEY_ISOLATED = "isolated";
    private final Object lock = new Object();
    private final Map<String, Long> isolatedInstances = new ConcurrentHashMapEx();

    public InstanceIsolationDiscoveryFilter() {
        EventManager.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onInstanceIsolatedEvent(InstanceIsolatedEvent event) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<String> iterator = this.isolatedInstances.keySet().iterator();
            while (iterator.hasNext()) {
                Long duration = this.isolatedInstances.get(iterator.next());
                if (System.currentTimeMillis() - duration <= 0L) continue;
                iterator.remove();
            }
            this.isolatedInstances.put(event.getInstanceId(), System.currentTimeMillis() + event.getWaitDurationInHalfOpenState().toMillis());
            LOGGER.info("isolate instance {} for {}ms", (Object)event.getInstanceId(), (Object)event.getWaitDurationInHalfOpenState().toMillis());
        }
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.instance.isolation.enabled", true).get();
    }

    public int getOrder() {
        return 32766;
    }

    public boolean isGroupingFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map instances = (Map)parent.data();
        if (this.isolatedInstances.isEmpty() || instances.isEmpty()) {
            return parent;
        }
        boolean changed = false;
        HashMap<String, MicroserviceInstance> result = new HashMap<String, MicroserviceInstance>(instances.size());
        for (Map.Entry item : instances.entrySet()) {
            Long duration = this.isolatedInstances.get(item.getKey());
            if (duration == null) {
                result.put((String)item.getKey(), (MicroserviceInstance)item.getValue());
                continue;
            }
            if (System.currentTimeMillis() - duration < 0L) {
                changed = true;
                continue;
            }
            Object object = this.lock;
            synchronized (object) {
                this.isolatedInstances.remove(item.getKey());
                LOGGER.info("try to recover instance {}", item.getKey());
            }
            result.put((String)item.getKey(), (MicroserviceInstance)item.getValue());
        }
        if (!changed || result.size() == 0) {
            return parent;
        }
        DiscoveryTreeNode child = (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, KEY_ISOLATED).data(result);
        parent.child(KEY_ISOLATED, child);
        Invocation invocation = (Invocation)context.getInputParameters();
        LOGGER.info("instance isolation discovery filter changed, current cached size {}/{}/{}", new Object[]{invocation.getAppId(), invocation.getMicroserviceName(), result.size()});
        return child;
    }
}

