/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.NextReceiverPolicy;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.ReceiverOptions;
import org.apache.qpid.protonj2.client.Sender;
import org.apache.qpid.protonj2.client.SenderOptions;
import org.apache.qpid.protonj2.client.Session;
import org.apache.qpid.protonj2.client.SessionOptions;
import org.apache.qpid.protonj2.client.StreamReceiverOptions;
import org.apache.qpid.protonj2.client.StreamSenderOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.futures.AsyncResult;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientFutureFactory;
import org.apache.qpid.protonj2.client.impl.ClientConnection;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientInstance;
import org.apache.qpid.protonj2.client.impl.ClientLocalTransactionContext;
import org.apache.qpid.protonj2.client.impl.ClientNextReceiverSelector;
import org.apache.qpid.protonj2.client.impl.ClientNoOpTransactionContext;
import org.apache.qpid.protonj2.client.impl.ClientReceiver;
import org.apache.qpid.protonj2.client.impl.ClientReceiverBuilder;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.client.impl.ClientSenderBuilder;
import org.apache.qpid.protonj2.client.impl.ClientSenderLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSessionBuilder;
import org.apache.qpid.protonj2.client.impl.ClientStreamReceiver;
import org.apache.qpid.protonj2.client.impl.ClientStreamSender;
import org.apache.qpid.protonj2.client.impl.ClientTransactionContext;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSession
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long INFINITE = -1L;
    private static final AtomicIntegerFieldUpdater<ClientSession> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientSession.class, "closed");
    private static final ClientNoOpTransactionContext NO_OP_TXN_CONTEXT = new ClientNoOpTransactionContext();
    private final ClientFuture<Session> openFuture;
    private final ClientFuture<Session> closeFuture;
    private final SessionOptions options;
    private final ClientConnection connection;
    private final Scheduler serializer;
    private final String sessionId;
    private final ClientSenderBuilder senderBuilder;
    private final ClientReceiverBuilder receiverBuilder;
    private ClientNextReceiverSelector nextReceiverSelector;
    private volatile int closed;
    private volatile ClientException failureCause;
    private ClientTransactionContext txnContext = NO_OP_TXN_CONTEXT;
    private org.apache.qpid.protonj2.engine.Session protonSession;

    ClientSession(ClientConnection connection, SessionOptions options, String sessionId, org.apache.qpid.protonj2.engine.Session session) {
        this.options = new SessionOptions(options);
        this.connection = connection;
        this.protonSession = (org.apache.qpid.protonj2.engine.Session)session.setLinkedResource((Object)this);
        this.sessionId = sessionId;
        this.serializer = connection.getScheduler();
        this.openFuture = connection.getFutureFactory().createFuture();
        this.closeFuture = connection.getFutureFactory().createFuture();
        this.senderBuilder = new ClientSenderBuilder(this);
        this.receiverBuilder = new ClientReceiverBuilder(this);
        this.configureSession(this.protonSession);
    }

    @Override
    public ClientInstance client() {
        return this.connection.client();
    }

    @Override
    public ClientConnection connection() {
        return this.connection;
    }

    @Override
    public Future<Session> openFuture() {
        return this.openFuture;
    }

    @Override
    public void close() {
        try {
            this.doClose(null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        try {
            this.doClose(error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public Future<Session> closeAsync() {
        return this.doClose(null);
    }

    @Override
    public Future<Session> closeAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Supplied error condition cannot be null");
        return this.doClose(error);
    }

    private Future<Session> doClose(ErrorCondition error) {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1) && !this.closeFuture.isDone()) {
            this.serializer.execute(() -> {
                if (this.protonSession.isLocallyOpen()) {
                    try {
                        this.protonSession.setCondition(ClientErrorCondition.asProtonErrorCondition(error));
                        this.protonSession.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        return this.closeFuture;
    }

    @Override
    public Receiver openReceiver(String address) throws ClientException {
        return this.openReceiver(address, null);
    }

    @Override
    public Receiver openReceiver(String address, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a receiver with a null address");
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.internalOpenReceiver(address, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.connection.request(this, createReceiver);
    }

    @Override
    public Receiver openDurableReceiver(String address, String subscriptionName) throws ClientException {
        return this.openDurableReceiver(address, subscriptionName, null);
    }

    @Override
    public Receiver openDurableReceiver(String address, String subscriptionName, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a receiver with a null address");
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.internalOpenDurableReceiver(address, subscriptionName, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.connection.request(this, createReceiver);
    }

    @Override
    public Receiver openDynamicReceiver() throws ClientException {
        return this.openDynamicReceiver(null, null);
    }

    @Override
    public Receiver openDynamicReceiver(Map<String, Object> dynamicNodeProperties) throws ClientException {
        return this.openDynamicReceiver(dynamicNodeProperties, null);
    }

    @Override
    public Receiver openDynamicReceiver(ReceiverOptions receiverOptions) throws ClientException {
        return this.openDynamicReceiver(null, receiverOptions);
    }

    @Override
    public Receiver openDynamicReceiver(Map<String, Object> dynamicNodeProperties, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.internalOpenDynamicReceiver(dynamicNodeProperties, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.connection.request(this, createReceiver);
    }

    @Override
    public Sender openSender(String address) throws ClientException {
        return this.openSender(address, null);
    }

    @Override
    public Sender openSender(String address, SenderOptions senderOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a sender with a null address");
        ClientFuture createSender = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createSender.complete(this.internalOpenSender(address, senderOptions));
            }
            catch (Throwable error) {
                createSender.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Sender)this.connection.request(this, createSender);
    }

    @Override
    public Sender openAnonymousSender() throws ClientException {
        return this.openAnonymousSender(null);
    }

    @Override
    public Sender openAnonymousSender(SenderOptions senderOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createSender = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createSender.complete(this.internalOpenAnonymousSender(senderOptions));
            }
            catch (Throwable error) {
                createSender.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Sender)this.connection.request(this, createSender);
    }

    @Override
    public Map<String, Object> properties() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringKeyedMap(this.protonSession.getRemoteProperties());
    }

    @Override
    public String[] offeredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonSession.getRemoteOfferedCapabilities());
    }

    @Override
    public String[] desiredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonSession.getRemoteDesiredCapabilities());
    }

    @Override
    public Session beginTransaction() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture beginFuture = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                if (this.txnContext == NO_OP_TXN_CONTEXT) {
                    this.txnContext = new ClientLocalTransactionContext(this);
                }
                this.txnContext.begin(beginFuture);
            }
            catch (Throwable error) {
                beginFuture.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Session)this.connection.request(this, beginFuture);
    }

    @Override
    public Session commitTransaction() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture commitFuture = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                this.txnContext.commit(commitFuture, false);
            }
            catch (Throwable error) {
                commitFuture.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Session)this.connection.request(this, commitFuture);
    }

    @Override
    public Session rollbackTransaction() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture rollbackFuture = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                this.txnContext.rollback(rollbackFuture, false);
            }
            catch (Throwable error) {
                rollbackFuture.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Session)this.connection.request(this, rollbackFuture);
    }

    @Override
    public Receiver nextReceiver() throws ClientException {
        return this.nextReceiver(this.options.defaultNextReceiverPolicy(), -1L, TimeUnit.MICROSECONDS);
    }

    @Override
    public Receiver nextReceiver(long timeout, TimeUnit unit) throws ClientException {
        return this.nextReceiver(this.options.defaultNextReceiverPolicy(), timeout, unit);
    }

    @Override
    public Receiver nextReceiver(NextReceiverPolicy policy) throws ClientException {
        return this.nextReceiver(policy, -1L, TimeUnit.MICROSECONDS);
    }

    @Override
    public Receiver nextReceiver(NextReceiverPolicy policy, long timeout, TimeUnit unit) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture nextPending = this.getFutureFactory().createFuture();
        this.serializer.execute(() -> {
            try {
                this.checkClosedOrFailed();
                this.getNextReceiverSelector().nextReceiver(nextPending, policy, unit.toMillis(timeout));
            }
            catch (Throwable error) {
                nextPending.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.connection.request(this, nextPending);
    }

    ClientReceiver internalOpenReceiver(String address, ReceiverOptions receiverOptions) throws ClientException {
        return (ClientReceiver)this.receiverBuilder.receiver(address, receiverOptions).open();
    }

    ClientStreamReceiver internalOpenStreamReceiver(String address, StreamReceiverOptions receiverOptions) throws ClientException {
        return (ClientStreamReceiver)this.receiverBuilder.streamReceiver(address, receiverOptions).open();
    }

    ClientReceiver internalOpenDurableReceiver(String address, String subscriptionName, ReceiverOptions receiverOptions) throws ClientException {
        return (ClientReceiver)this.receiverBuilder.durableReceiver(address, subscriptionName, receiverOptions).open();
    }

    ClientReceiver internalOpenDynamicReceiver(Map<String, Object> dynamicNodeProperties, ReceiverOptions receiverOptions) throws ClientException {
        return (ClientReceiver)this.receiverBuilder.dynamicReceiver(dynamicNodeProperties, receiverOptions).open();
    }

    ClientSender internalOpenSender(String address, SenderOptions senderOptions) throws ClientException {
        return (ClientSender)this.senderBuilder.sender(address, senderOptions).open();
    }

    ClientSender internalOpenAnonymousSender(SenderOptions senderOptions) throws ClientException {
        if (this.connection.openFuture().isDone()) {
            this.connection.checkAnonymousRelaySupported();
            return (ClientSender)this.senderBuilder.anonymousSender(senderOptions).open();
        }
        return this.senderBuilder.anonymousSender(senderOptions);
    }

    ClientStreamSender internalOpenStreamSender(String address, StreamSenderOptions senderOptions) throws ClientException {
        return (ClientStreamSender)this.senderBuilder.streamSender(address, senderOptions).open();
    }

    ClientSession open() {
        ((org.apache.qpid.protonj2.engine.Session)((org.apache.qpid.protonj2.engine.Session)((org.apache.qpid.protonj2.engine.Session)((org.apache.qpid.protonj2.engine.Session)this.protonSession.localOpenHandler(this::handleLocalOpen)).localCloseHandler(this::handleLocalClose)).openHandler(this::handleRemoteOpen)).closeHandler(this::handleRemoteClose)).engineShutdownHandler(this::handleEngineShutdown);
        try {
            this.protonSession.open();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    Scheduler getScheduler() {
        return this.serializer;
    }

    ClientFutureFactory getFutureFactory() {
        return this.connection.getFutureFactory();
    }

    ClientException getFailureCause() {
        return this.failureCause;
    }

    boolean isClosed() {
        return this.closed > 0;
    }

    Future<?> scheduleRequestTimeout(AsyncResult<?> request, long timeout, Supplier<ClientException> errorSupplier) {
        if (timeout != -1L) {
            return this.serializer.schedule(() -> request.failed((ClientException)errorSupplier.get()), timeout, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    <T> T request(Object requestor, ClientFuture<T> request) throws ClientException {
        return this.connection.request(requestor, request);
    }

    String id() {
        return this.sessionId;
    }

    SessionOptions options() {
        return this.options;
    }

    org.apache.qpid.protonj2.engine.Session getProtonSession() {
        return this.protonSession;
    }

    ClientTransactionContext getTransactionContext() {
        return this.txnContext;
    }

    ClientConnection getConnection() {
        return this.connection;
    }

    private org.apache.qpid.protonj2.engine.Session configureSession(org.apache.qpid.protonj2.engine.Session protonSession) {
        protonSession.setLinkedResource((Object)this);
        protonSession.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(this.options.offeredCapabilities()));
        protonSession.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(this.options.desiredCapabilities()));
        protonSession.setProperties(ClientConversionSupport.toSymbolKeyedMap(this.options.properties()));
        return protonSession;
    }

    protected void checkClosedOrFailed() throws ClientException {
        if (this.isClosed()) {
            throw new ClientIllegalStateException("The Session was explicitly closed", this.failureCause);
        }
        if (this.failureCause != null) {
            throw this.failureCause;
        }
    }

    private void waitForOpenToComplete() throws ClientException {
        if (!this.openFuture.isComplete() || this.openFuture.isFailed()) {
            try {
                this.openFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.interrupted();
                if (this.failureCause != null) {
                    throw this.failureCause;
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e.getCause());
            }
        }
    }

    private ClientNextReceiverSelector getNextReceiverSelector() {
        if (this.nextReceiverSelector == null) {
            this.nextReceiverSelector = new ClientNextReceiverSelector(this);
        }
        return this.nextReceiverSelector;
    }

    private void handleLocalOpen(org.apache.qpid.protonj2.engine.Session session) {
        if (this.options.openTimeout() > 0L) {
            this.serializer.schedule(() -> {
                if (!this.openFuture.isDone()) {
                    this.immediateSessionShutdown(new ClientOperationTimedOutException("Session open timed out waiting for remote to respond"));
                }
            }, this.options.openTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void handleLocalClose(org.apache.qpid.protonj2.engine.Session session) {
        if (session.isRemotelyOpen() && this.failureCause == null && !session.getEngine().isShutdown()) {
            long timeout = this.options.closeTimeout();
            if (timeout > 0L) {
                this.scheduleRequestTimeout(this.closeFuture, timeout, () -> new ClientOperationTimedOutException("Session close timed out waiting for remote to respond"));
            }
        } else {
            this.immediateSessionShutdown(this.failureCause);
        }
    }

    private void handleRemoteOpen(org.apache.qpid.protonj2.engine.Session session) {
        this.openFuture.complete(this);
        LOG.trace("Session:{} opened successfully.", (Object)this.id());
        session.senders().forEach(sender -> {
            if (!sender.isLocallyOpen()) {
                ClientSenderLinkType clientSender = (ClientSenderLinkType)sender.getLinkedResource();
                if (this.connection.getCapabilities().anonymousRelaySupported()) {
                    clientSender.open();
                } else {
                    clientSender.handleAnonymousRelayNotSupported();
                }
            }
        });
    }

    private void handleRemoteClose(org.apache.qpid.protonj2.engine.Session session) {
        if (session.isLocallyOpen()) {
            this.immediateSessionShutdown(ClientExceptionSupport.convertToSessionClosedException(session.getRemoteCondition()));
        } else {
            this.immediateSessionShutdown(this.failureCause);
        }
    }

    private void handleEngineShutdown(Engine engine) {
        if (!this.connection.getEngine().isShutdown()) {
            this.protonSession.localCloseHandler(null);
            this.protonSession.close();
            this.protonSession = this.configureSession(ClientSessionBuilder.recreateSession(this.connection, this.protonSession, this.options));
            if (this.nextReceiverSelector != null) {
                this.nextReceiverSelector.handleReconnect();
            }
            this.open();
        } else {
            Connection connection = engine.connection();
            ClientConnectionRemotelyClosedException failureCause = connection.getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(connection.getRemoteCondition()) : (engine.failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.failureCause()) : (!this.isClosed() ? new ClientConnectionRemotelyClosedException("Remote closed without a specific error condition") : null));
            this.immediateSessionShutdown(failureCause);
        }
    }

    private void immediateSessionShutdown(ClientException failureCause) {
        if (this.failureCause == null) {
            this.failureCause = failureCause;
        }
        try {
            this.protonSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.nextReceiverSelector != null) {
            this.nextReceiverSelector.handleShutdown();
        }
        if (failureCause != null) {
            this.openFuture.failed(failureCause);
        } else {
            this.openFuture.complete(this);
        }
        this.closeFuture.complete(this);
    }
}

