/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl.sasl;

import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.EngineState;
import org.apache.qpid.protonj2.engine.HeaderEnvelope;
import org.apache.qpid.protonj2.engine.IncomingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.SASLEnvelope;
import org.apache.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineNoOpSaslDriver;
import org.apache.qpid.protonj2.engine.impl.sasl.ProtonEngineSaslDriver;
import org.apache.qpid.protonj2.engine.impl.sasl.ProtonSaslContext;

public final class ProtonSaslHandler
implements EngineHandler {
    private EngineHandlerContext context;
    private ProtonEngineSaslDriver driver;
    private ProtonEngine engine;
    private ProtonSaslContext saslContext;

    public boolean isDone() {
        return this.saslContext != null ? this.saslContext.isDone() : false;
    }

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.engine = (ProtonEngine)context.engine();
        this.driver = new ProtonEngineSaslDriver(this.engine, this);
        this.context = context;
        this.engine.registerSaslDriver(this.driver);
    }

    @Override
    public void handlerRemoved(EngineHandlerContext context) {
        this.driver = null;
        this.saslContext = null;
        this.engine = null;
        this.context = null;
        if (context.engine().state() == EngineState.IDLE) {
            ((ProtonEngine)context.engine()).registerSaslDriver(ProtonEngineNoOpSaslDriver.INSTANCE);
        }
    }

    @Override
    public void engineStarting(EngineHandlerContext context) {
        this.driver.handleEngineStarting(this.engine);
    }

    @Override
    public void handleRead(EngineHandlerContext context, HeaderEnvelope header) {
        if (this.isDone()) {
            context.fireRead(header);
        } else {
            this.saslContext = this.driver.context();
            if (this.saslContext == null) {
                this.saslContext = this.driver.server();
            }
            header.invoke(this.saslContext.headerReadContext(), context);
        }
    }

    @Override
    public void handleRead(EngineHandlerContext context, SASLEnvelope frame) {
        if (this.isDone()) {
            throw new ProtocolViolationException("Unexpected SASL Frame: SASL processing has already completed");
        }
        frame.invoke(this.safeGetSaslContext().saslReadContext(), context);
    }

    @Override
    public void handleRead(EngineHandlerContext context, IncomingAMQPEnvelope frame) {
        if (!this.isDone()) {
            throw new ProtocolViolationException("Unexpected AMQP Frame: SASL processing not yet completed");
        }
        context.fireRead(frame);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, HeaderEnvelope frame) {
        if (this.isDone()) {
            context.fireWrite(frame);
        } else {
            this.saslContext = this.driver.context();
            if (this.saslContext == null) {
                this.saslContext = this.driver.client();
            }
            frame.invoke(this.saslContext.headerWriteContext(), context);
        }
    }

    @Override
    public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope frame) {
        if (!this.isDone()) {
            throw new ProtocolViolationException("Unexpected AMQP Performative: SASL processing not yet completed");
        }
        context.fireWrite(frame);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, SASLEnvelope frame) {
        if (this.isDone()) {
            throw new ProtocolViolationException("Unexpected SASL Performative: SASL processing has yet completed");
        }
        frame.invoke(this.safeGetSaslContext().saslWriteContext(), context);
    }

    ProtonEngine engine() {
        return this.engine;
    }

    EngineHandlerContext context() {
        return this.context;
    }

    private ProtonSaslContext safeGetSaslContext() {
        if (this.saslContext != null) {
            return this.saslContext;
        }
        throw new IllegalStateException("Cannot process incoming SASL performative, driver not yet initialized");
    }
}

