/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.io.Serializable;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.deser.DeserializerCache;
import tools.jackson.databind.deser.DeserializerFactory;

public abstract class DeserializationContexts
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final transient TokenStreamFactory _streamFactory;
    protected final transient DeserializerFactory _deserializerFactory;
    protected final transient DeserializerCache _cache;

    protected DeserializationContexts() {
        this(null, null, null);
    }

    protected DeserializationContexts(TokenStreamFactory tsf, DeserializerFactory deserializerFactory, DeserializerCache cache) {
        this._streamFactory = tsf;
        this._deserializerFactory = deserializerFactory;
        this._cache = cache;
    }

    public DeserializationContexts forMapper(Object mapper, DeserializationConfig config, TokenStreamFactory tsf, DeserializerFactory deserializerFactory) {
        return this.forMapper(mapper, tsf, deserializerFactory, new DeserializerCache(config.getCacheProvider().forDeserializerCache(config)));
    }

    protected abstract DeserializationContexts forMapper(Object var1, TokenStreamFactory var2, DeserializerFactory var3, DeserializerCache var4);

    public abstract DeserializationContextExt createContext(DeserializationConfig var1, FormatSchema var2, InjectableValues var3);

    public void flushCachedDeserializers() {
        this._cache.flushCachedDeserializers();
    }

    public static class DefaultImpl
    extends DeserializationContexts {
        private static final long serialVersionUID = 3L;

        public DefaultImpl() {
        }

        public DefaultImpl(TokenStreamFactory tsf, DeserializerFactory serializerFactory, DeserializerCache cache) {
            super(tsf, serializerFactory, cache);
        }

        @Override
        public DeserializationContexts forMapper(Object mapper, TokenStreamFactory tsf, DeserializerFactory serializerFactory, DeserializerCache cache) {
            return new DefaultImpl(tsf, serializerFactory, cache);
        }

        @Override
        public DeserializationContextExt createContext(DeserializationConfig config, FormatSchema schema, InjectableValues injectables) {
            return new DeserializationContextExt.Impl(this._streamFactory, this._deserializerFactory, this._cache, config, schema, injectables);
        }

        public DeserializerCache cacheForTests() {
            return this._cache;
        }
    }
}

