/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.DiagnosticsContext;
import org.jooq.DiagnosticsListener;
import org.jooq.DiagnosticsListenerProvider;

final class DiagnosticsListeners
implements DiagnosticsListener {
    final DiagnosticsListener[] listeners;

    DiagnosticsListeners(DiagnosticsListenerProvider[] providers) {
        this.listeners = new DiagnosticsListener[providers.length];
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = providers[i].provide();
        }
    }

    static final DiagnosticsListeners get(Configuration configuration) {
        return new DiagnosticsListeners(configuration.diagnosticsListenerProviders());
    }

    @Override
    public final void tooManyRowsFetched(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.tooManyRowsFetched(ctx);
        }
    }

    @Override
    public final void tooManyColumnsFetched(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.tooManyColumnsFetched(ctx);
        }
    }

    @Override
    public final void unnecessaryWasNullCall(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.unnecessaryWasNullCall(ctx);
        }
    }

    @Override
    public final void missingWasNullCall(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.missingWasNullCall(ctx);
        }
    }

    @Override
    public final void duplicateStatements(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.duplicateStatements(ctx);
        }
    }

    @Override
    public final void repeatedStatements(DiagnosticsContext ctx) {
        for (DiagnosticsListener listener : this.listeners) {
            listener.repeatedStatements(ctx);
        }
    }
}

