/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

public class VolumeIOStats {
    private String metricsSourceName = VolumeIOStats.class.getSimpleName();
    private String storageDirectory;
    private final MetricsRegistry registry = new MetricsRegistry("VolumeIOStats");
    @Metric
    private MutableCounterLong readBytes;
    @Metric
    private MutableCounterLong readOpCount;
    @Metric
    private MutableCounterLong writeBytes;
    @Metric
    private MutableCounterLong writeOpCount;
    @Metric
    private MutableRate readTime;
    @Metric
    private MutableQuantiles[] readLatencyQuantiles;
    @Metric
    private MutableRate writeTime;
    @Metric
    private MutableQuantiles[] writeLatencyQuantiles;

    @Deprecated
    public VolumeIOStats() {
        this.init();
    }

    public VolumeIOStats(String identifier, String storageDirectory, int[] intervals) {
        this.metricsSourceName = this.metricsSourceName + '-' + identifier;
        this.storageDirectory = storageDirectory;
        if (intervals != null && intervals.length > 0) {
            int length = intervals.length;
            this.readLatencyQuantiles = new MutableQuantiles[intervals.length];
            this.writeLatencyQuantiles = new MutableQuantiles[intervals.length];
            for (int i = 0; i < length; ++i) {
                this.readLatencyQuantiles[i] = this.registry.newQuantiles("readLatency" + intervals[i] + "s", "Read Data File Io Latency in ms", "ops", "latency", intervals[i]);
                this.writeLatencyQuantiles[i] = this.registry.newQuantiles("writeLatency" + intervals[i] + "s", "Write Data File Io Latency in ms", "ops", "latency", intervals[i]);
            }
        }
        this.init();
    }

    public void init() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.metricsSourceName, "Volume I/O Statistics", (Object)this);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.metricsSourceName);
    }

    public String getMetricsSourceName() {
        return this.metricsSourceName;
    }

    public void incReadBytes(long bytesRead) {
        this.readBytes.incr(bytesRead);
    }

    public void incReadOpCount() {
        this.readOpCount.incr();
    }

    public void incWriteBytes(long bytesWritten) {
        this.writeBytes.incr(bytesWritten);
    }

    public void incWriteOpCount() {
        this.writeOpCount.incr();
    }

    public void incReadTime(long time) {
        this.readTime.add(time);
        for (MutableQuantiles q : this.readLatencyQuantiles) {
            q.add(time);
        }
    }

    public void incWriteTime(long time) {
        this.writeTime.add(time);
        for (MutableQuantiles q : this.writeLatencyQuantiles) {
            q.add(time);
        }
    }

    public long getReadBytes() {
        return this.readBytes.value();
    }

    public long getWriteBytes() {
        return this.writeBytes.value();
    }

    public long getReadOpCount() {
        return this.readOpCount.value();
    }

    public long getWriteOpCount() {
        return this.writeOpCount.value();
    }

    public long getReadTime() {
        return (long)this.readTime.lastStat().total();
    }

    public long getWriteTime() {
        return (long)this.writeTime.lastStat().total();
    }

    @Metric
    public String getStorageDirectory() {
        return this.storageDirectory;
    }
}

