/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.snapshot.OmSnapshotLocalDataManager;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotPurgeResponse
extends OMClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotPurgeResponse.class);
    private final List<String> snapshotDbKeys;
    private final Map<String, SnapshotInfo> updatedSnapInfos;

    public OMSnapshotPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<String> snapshotDbKeys, Map<String, SnapshotInfo> updatedSnapInfos) {
        super(omResponse);
        this.snapshotDbKeys = snapshotDbKeys;
        this.updatedSnapInfos = updatedSnapInfos;
    }

    public OMSnapshotPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
        this.snapshotDbKeys = null;
        this.updatedSnapInfos = null;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OmMetadataManagerImpl metadataManager = (OmMetadataManagerImpl)omMetadataManager;
        this.updateSnapInfo(metadataManager, batchOperation, this.updatedSnapInfos);
        for (String dbKey : this.snapshotDbKeys) {
            SnapshotInfo snapshotInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().getSkipCache((Object)dbKey);
            if (snapshotInfo == null) continue;
            ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager().invalidateCacheEntry(snapshotInfo.getSnapshotId());
            ((OmMetadataManagerImpl)omMetadataManager).getSnapshotChainManager().removeFromSnapshotIdToTable(snapshotInfo.getSnapshotId());
            OmSnapshotLocalDataManager snapshotLocalDataManager = ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager().getSnapshotLocalDataManager();
            this.deleteCheckpointDirectory(snapshotLocalDataManager, omMetadataManager, snapshotInfo);
            omMetadataManager.getSnapshotInfoTable().deleteWithBatch(batchOperation, (Object)dbKey);
        }
    }

    private void updateSnapInfo(OmMetadataManagerImpl metadataManager, BatchOperation batchOp, Map<String, SnapshotInfo> snapshotInfos) throws IOException {
        for (Map.Entry<String, SnapshotInfo> entry : snapshotInfos.entrySet()) {
            metadataManager.getSnapshotInfoTable().putWithBatch(batchOp, (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private void deleteCheckpointDirectory(OmSnapshotLocalDataManager snapshotLocalDataManager, OMMetadataManager omMetadataManager, SnapshotInfo snapshotInfo) {
        block6: {
            OMLockDetails omLockDetails = omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
            boolean acquiredSnapshotLock = omLockDetails.isLockAcquired();
            if (acquiredSnapshotLock) {
                Path snapshotDirPath = OmSnapshotManager.getSnapshotPath(omMetadataManager, snapshotInfo);
                try {
                    try {
                        FileUtils.deleteDirectory((File)snapshotDirPath.toFile());
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to delete snapshot directory {} for snapshot {}", new Object[]{snapshotDirPath, snapshotInfo.getTableKey(), ex});
                        omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
                    throw throwable;
                }
                omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_DB_LOCK, new String[]{snapshotInfo.getSnapshotId().toString()});
            }
        }
    }

    @VisibleForTesting
    public Map<String, SnapshotInfo> getUpdatedSnapInfos() {
        return this.updatedSnapInfos;
    }
}

