/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "deletedTable", "multipartInfoTable", "bucketTable"})
public class S3MultipartUploadCommitPartResponse
extends OmKeyResponse {
    private final String multipartKey;
    private final String openKey;
    private final OmMultipartKeyInfo omMultipartKeyInfo;
    private final Map<String, RepeatedOmKeyInfo> keyToDeleteMap;
    private final OmKeyInfo openPartKeyInfoToBeDeleted;
    private final OmBucketInfo omBucketInfo;
    private final long bucketId;

    public S3MultipartUploadCommitPartResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String multipartKey, String openKey, @Nullable OmMultipartKeyInfo omMultipartKeyInfo, @Nullable Map<String, RepeatedOmKeyInfo> keyToDeleteMap, @Nullable OmKeyInfo openPartKeyInfoToBeDeleted, @Nonnull OmBucketInfo omBucketInfo, long bucketId, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.multipartKey = multipartKey;
        this.openKey = openKey;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.keyToDeleteMap = keyToDeleteMap;
        this.openPartKeyInfoToBeDeleted = openPartKeyInfoToBeDeleted;
        this.omBucketInfo = omBucketInfo;
        this.bucketId = bucketId;
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((long)this.bucketId, (OmKeyInfo)this.openPartKeyInfoToBeDeleted, (long)this.openPartKeyInfoToBeDeleted.getUpdateID());
            String deleteKey = omMetadataManager.getOzoneDeletePathKey(this.openPartKeyInfoToBeDeleted.getObjectID(), this.multipartKey);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKey, (Object)repeatedOmKeyInfo);
        }
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.keyToDeleteMap != null) {
            for (Map.Entry<String, RepeatedOmKeyInfo> entry : this.keyToDeleteMap.entrySet()) {
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.multipartKey, (Object)this.omMultipartKeyInfo);
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.openKey);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }

    @VisibleForTesting
    public Map<String, RepeatedOmKeyInfo> getKeyToDelete() {
        return this.keyToDeleteMap;
    }
}

