/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.ratis.util.function.CheckedBiConsumer;

public abstract class OMVolumeAclRequest
extends OMVolumeRequest {
    private final VolumeAclOp omVolumeAclOp;

    OMVolumeAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, VolumeAclOp aclOp) {
        super(omRequest);
        this.omVolumeAclOp = aclOp;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        List<OzoneAcl> ozoneAcls;
        long trxnLogIndex;
        block21: {
            trxnLogIndex = context.getIndex();
            String volume = this.getVolumeName();
            ozoneAcls = this.getAcls();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    OmVolumeArgs omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
                    boolean applyAcl = true;
                    try {
                        this.omVolumeAclOp.accept(ozoneAcls, omVolumeArgs);
                    }
                    catch (OMException oMException) {
                        applyAcl = false;
                    }
                    if (applyAcl) {
                        long modificationTime = omVolumeArgs.getModificationTime();
                        if (this.getOmRequest().getAddAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getRemoveAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                        }
                        omVolumeArgs.setModificationTime(modificationTime);
                        omVolumeArgs.setUpdateID(trxnLogIndex);
                        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), CacheValue.get((long)trxnLogIndex, (Object)omVolumeArgs));
                    }
                    omClientResponse = this.onSuccess(omResponse, omVolumeArgs, applyAcl);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumVolumeUpdateFails();
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        if (ozoneAcls != null) {
            auditMap.put("acl", ozoneAcls.toString());
        }
        this.onComplete(result, exception, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract List<OzoneAcl> getAcls();

    abstract String getVolumeName();

    abstract OzoneObj getObject();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmVolumeArgs var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, Exception var2);

    abstract void onComplete(OMClientRequest.Result var1, Exception var2, long var3, AuditLogger var5, Map<String, String> var6);

    public static interface VolumeAclOp
    extends CheckedBiConsumer<List<OzoneAcl>, OmVolumeArgs, IOException> {
    }
}

