/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseCallbackExecutor<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseCallbackExecutor.class);
    private final T resource;
    private final Callable<Void> callback;

    public LeaseCallbackExecutor(T resource, Callable<Void> callback) {
        this.resource = resource;
        this.callback = callback;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing callbacks for lease on {}", this.resource);
        }
        if (this.callback != null) {
            try {
                this.callback.call();
            }
            catch (Exception e) {
                LOG.warn("Exception while executing callback for lease on {}", this.resource, (Object)e);
            }
        }
    }
}

