/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
@Metrics(about="Recon Task Controller Metrics", context="ozone")
public final class ReconTaskControllerMetrics {
    private static final String SOURCE_NAME = ReconTaskControllerMetrics.class.getSimpleName();
    @Metric(about="Current number of Recon events including OM DB Update batch events and Recon reinit events in the queue")
    private MutableGaugeLong eventCurrentQueueSize;
    @Metric(about="Total count of OM DB Update events plus Recon reinit events buffered since startup")
    private MutableCounterLong eventBufferedCount;
    @Metric(about="Count of events dropped due to buffer issues")
    private MutableCounterLong eventDropCount;
    @Metric(about="Total count of all Recon events processed")
    private MutableCounterLong totalEventCount;
    @Metric(about="Count of checkpoint creation failures")
    private MutableCounterLong reprocessCheckpointFailures;
    @Metric(about="Count of reprocess execution failures")
    private MutableCounterLong reprocessExecutionFailures;
    @Metric(about="Count of stage database replacement failures")
    private MutableCounterLong reprocessStageDatabaseFailures;
    @Metric(about="Count of all successful reprocess executions")
    private MutableCounterLong reprocessSuccessCount;
    @Metric(about="Total count of reinitialization events submitted to queue")
    private MutableCounterLong totalReprocessSubmittedToQueue;

    private ReconTaskControllerMetrics() {
    }

    public static ReconTaskControllerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ReconTaskControllerMetrics)ms.register(SOURCE_NAME, "Recon Task Controller Metrics", (Object)new ReconTaskControllerMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void setEventCurrentQueueSize(long size) {
        this.eventCurrentQueueSize.set(size);
    }

    public void incrEventBufferedCount(long count) {
        this.eventBufferedCount.incr(count);
    }

    public void incrEventDropCount(long count) {
        this.eventDropCount.incr(count);
    }

    public void incrTotalEventCount(long count) {
        this.totalEventCount.incr(count);
    }

    public void incrReprocessCheckpointFailures() {
        this.reprocessCheckpointFailures.incr();
    }

    public void incrReprocessExecutionFailures() {
        this.reprocessExecutionFailures.incr();
    }

    public void incrReprocessStageDatabaseFailures() {
        this.reprocessStageDatabaseFailures.incr();
    }

    public void incrReprocessSuccessCount() {
        this.reprocessSuccessCount.incr();
    }

    public void incrTotalReprocessSubmittedToQueue() {
        this.totalReprocessSubmittedToQueue.incr();
    }

    public long getEventCurrentQueueSize() {
        return this.eventCurrentQueueSize.value();
    }

    public long getEventBufferedCount() {
        return this.eventBufferedCount.value();
    }

    public long getEventDropCount() {
        return this.eventDropCount.value();
    }

    public long getTotalEventCount() {
        return this.totalEventCount.value();
    }

    public long getReprocessCheckpointFailures() {
        return this.reprocessCheckpointFailures.value();
    }

    public long getReprocessExecutionFailures() {
        return this.reprocessExecutionFailures.value();
    }

    public long getReprocessStageDatabaseFailures() {
        return this.reprocessStageDatabaseFailures.value();
    }

    public long getReprocessSuccessCount() {
        return this.reprocessSuccessCount.value();
    }

    public long getTotalReprocessSubmittedToQueue() {
        return this.totalReprocessSubmittedToQueue.value();
    }
}

