/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.logs.container.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.ozone.debug.logs.container.utils.ContainerDatanodeDatabase;
import org.apache.hadoop.ozone.debug.logs.container.utils.DatanodeContainerInfo;

public class ContainerLogFileParser {
    private static final int MAX_OBJ_IN_LIST = 5000;
    private static final String LOG_FILE_MARKER = ".log.";
    private static final String LOG_LINE_SPLIT_REGEX = " \\| ";
    private static final String KEY_VALUE_SPLIT_REGEX = "=";
    private static final String KEY_ID = "ID";
    private static final String KEY_BCSID = "BCSID";
    private static final String KEY_STATE = "State";
    private static final String KEY_INDEX = "Index";
    private final AtomicBoolean hasErrorOccurred = new AtomicBoolean(false);

    public void processLogEntries(String logDirectoryPath, ContainerDatanodeDatabase dbstore, int threadCount) throws SQLException, IOException, InterruptedException {
        try (Stream<Path> paths = Files.walk(Paths.get(logDirectoryPath, new String[0]), new FileVisitOption[0]);){
            List files = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
            CountDownLatch latch = new CountDownLatch(files.size());
            for (Path file : files) {
                Path fileNamePath = file.getFileName();
                String fileName = fileNamePath != null ? fileNamePath.toString() : "";
                int pos = fileName.indexOf(LOG_FILE_MARKER);
                if (pos == -1) {
                    System.out.println("Filename format is incorrect (missing .log.): " + fileName);
                    continue;
                }
                String datanodeId = fileName.substring(pos + 5);
                if (datanodeId.isEmpty()) {
                    System.out.println("Filename format is incorrect, datanodeId is missing or empty: " + fileName);
                    continue;
                }
                executorService.submit(() -> {
                    String threadName = Thread.currentThread().getName();
                    try {
                        System.out.println(threadName + " is starting to process file: " + file.toString());
                        this.processFile(file.toString(), dbstore, datanodeId);
                    }
                    catch (Exception e) {
                        System.err.println("Thread " + threadName + " is stopping to process the file: " + file.toString() + " due to SQLException: " + e.getMessage());
                        this.hasErrorOccurred.set(true);
                    }
                    finally {
                        try {
                            latch.countDown();
                            System.out.println(threadName + " finished processing file: " + file.toString() + ", Latch count after countdown: " + latch.getCount());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            latch.await();
            executorService.shutdown();
            if (this.hasErrorOccurred.get()) {
                throw new SQLException("Log file processing failed.");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(String logFilePath, ContainerDatanodeDatabase dbstore, String datanodeId) throws SQLException, IOException {
        block25: {
            block24: {
                batchList = new ArrayList<DatanodeContainerInfo>(5100);
                reader = Files.newBufferedReader(Paths.get(logFilePath, new String[0]), StandardCharsets.UTF_8);
lbl4:
                // 4 sources

                while (true) {
                    line = reader.readLine();
                    if (line != null) {
                        parts = line.split(" \\| ");
                        timestamp = parts[0].trim();
                        logLevel = parts[1].trim();
                        id = null;
                        index = null;
                        errorMessage = "No error";
                        builder = new DatanodeContainerInfo.Builder().setDatanodeId(datanodeId).setTimestamp(timestamp).setLogLevel(logLevel);
                        break block24;
                    }
                    if (batchList.isEmpty() != false) return;
                    dbstore.insertContainerDatanodeData(batchList);
                    batchList.clear();
                    return;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            for (i = 2; i < parts.length; ++i) {
                part = parts[i].trim();
                if (part.contains("=")) {
                    keyValue = part.split("=", 2);
                    if (keyValue.length != 2) continue;
                    key = keyValue[0].trim();
                    value = keyValue[1].trim();
                    var19_22 = key;
                    var20_23 = -1;
                    switch (var19_22.hashCode()) {
                        case 2331: {
                            if (!var19_22.equals("ID")) break;
                            var20_23 = 0;
                            break;
                        }
                        case 63030477: {
                            if (!var19_22.equals("BCSID")) break;
                            var20_23 = 1;
                            break;
                        }
                        case 80204913: {
                            if (!var19_22.equals("State")) break;
                            var20_23 = 2;
                            break;
                        }
                        case 70793394: {
                            if (!var19_22.equals("Index")) break;
                            var20_23 = 3;
                            break;
                        }
                    }
                    switch (var20_23) {
                        case 0: {
                            id = value;
                            builder.setContainerId(Long.parseLong(value));
                            break;
                        }
                        case 1: {
                            builder.setBcsid(Long.parseLong(value));
                            break;
                        }
                        case 2: {
                            builder.setState(value.replace("|", "").trim());
                            break;
                        }
                        case 3: {
                            index = value;
                            builder.setIndexValue(Integer.parseInt(value));
                            break;
                        }
                    }
                    continue;
                }
                if (part.isEmpty()) continue;
                errorMessage = part.replace("|", "").trim();
            }
            builder.setErrorMessage(errorMessage);
            if (index == null || !index.equals("0")) ** GOTO lbl-1000
            if (id == null) break block25;
            batchList.add(builder.build());
            if (batchList.size() < 5000) ** GOTO lbl4
            dbstore.insertContainerDatanodeData(batchList);
            batchList.clear();
        }
        System.err.println("Log line does not have all required fields: " + line);
        ** continue;
    }
}

