/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.UpdateLoader;
import org.apache.derby.io.StorageFile;

final class JarLoader
extends SecureClassLoader {
    private final String[] name;
    private StorageFile installedJar;
    private JarFile jar;
    private boolean isStream;
    private UpdateLoader updateLoader;
    private HeaderPrintWriter vs;

    JarLoader(UpdateLoader updateLoader, String[] stringArray, HeaderPrintWriter headerPrintWriter) {
        this.updateLoader = updateLoader;
        this.name = stringArray;
        this.vs = headerPrintWriter;
    }

    void initialize() {
        Exception exception;
        String string = this.name[0];
        String string2 = this.name[1];
        try {
            this.installedJar = this.updateLoader.getJarReader().getJarFile(string, string2);
            if (this.installedJar instanceof File) {
                try {
                    this.jar = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                        @Override
                        public JarFile run() throws IOException {
                            return new JarFile((File)((Object)JarLoader.this.installedJar));
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                return;
            }
            this.isStream = true;
            return;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (StandardException standardException) {
            exception = standardException;
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C003", this.getJarName(), exception));
        }
        this.setInvalid();
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (!(!string.startsWith("org.apache.derby.") || string.startsWith("org.apache.derby.jdbc.") || string.startsWith("org.apache.derby.vti.") || string.startsWith("org.apache.derby.agg.") || string.startsWith("org.apache.derby.optional.") || string.startsWith("org.apache.derby.impl.tools.optional."))) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException(string);
            throw classNotFoundException;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.updateLoader == null) {
                throw new ClassNotFoundException(MessageService.getTextMessage("C004", string));
            }
            Class clazz = this.updateLoader.loadClass(string, bl);
            if (clazz == null) {
                throw classNotFoundException;
            }
            return clazz;
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.updateLoader == null) {
            return null;
        }
        return this.updateLoader.getResourceAsStream(string);
    }

    final String getJarName() {
        return IdUtil.mkQualifiedName(this.name);
    }

    Class loadClassData(String string, String string2, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        try {
            if (this.jar != null) {
                return this.loadClassDataFromJar(string, string2, bl);
            }
            if (this.isStream) {
                return this.loadClassData(this.installedJar.getInputStream(), string, string2, bl);
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage("C007", string, this.getJarName(), iOException));
            }
            return null;
        }
    }

    InputStream getStream(String string) {
        if (this.updateLoader == null) {
            return null;
        }
        if (this.jar != null) {
            return this.getRawStream(string);
        }
        if (this.isStream) {
            try {
                return this.getRawStream(this.installedJar.getInputStream(), string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassDataFromJar(String string, String string2, boolean bl) throws IOException {
        JarEntry jarEntry = this.jar.getJarEntry(string2);
        if (jarEntry == null) {
            return null;
        }
        try (InputStream inputStream = this.jar.getInputStream(jarEntry);){
            Class clazz = this.loadClassData(jarEntry, inputStream, string, bl);
            return clazz;
        }
    }

    private Class loadClassData(InputStream inputStream, String string, String string2, boolean bl) throws IOException {
        JarEntry jarEntry;
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        do {
            if ((jarEntry = jarInputStream.getNextJarEntry()) != null) continue;
            jarInputStream.close();
            return null;
        } while (!jarEntry.getName().equals(string2));
        Class clazz = this.loadClassData(jarEntry, jarInputStream, string, bl);
        jarInputStream.close();
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassData(JarEntry jarEntry, InputStream inputStream, String string, boolean bl) throws IOException {
        byte[] byArray = this.readData(jarEntry, inputStream, string);
        Object[] objectArray = this.getSigners(string, jarEntry);
        UpdateLoader updateLoader = this.updateLoader;
        synchronized (updateLoader) {
            Class<?> clazz = this.updateLoader.checkLoaded(string, bl);
            if (clazz == null) {
                clazz = this.defineClass(string, byArray, 0, byArray.length, (CodeSource)null);
                if (objectArray != null) {
                    this.setSigners(clazz, objectArray);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
    }

    Class checkLoaded(String string, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    void setInvalid() {
        this.updateLoader = null;
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jar = null;
        }
        this.isStream = false;
    }

    private InputStream getRawStream(String string) {
        try {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry == null) {
                return null;
            }
            return this.jar.getInputStream(jarEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getRawStream(InputStream inputStream, String string) {
        JarInputStream jarInputStream = null;
        try {
            JarEntry jarEntry;
            jarInputStream = new JarInputStream(inputStream);
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().equals(string)) continue;
                int n = (int)jarEntry.getSize();
                if (n == -1) {
                    n = 8192;
                }
                InputStream inputStream2 = AccessibleByteArrayOutputStream.copyStream(jarInputStream, n);
                return inputStream2;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    byte[] readData(JarEntry jarEntry, InputStream inputStream, String string) throws IOException {
        try {
            int n;
            int n2 = (int)jarEntry.getSize();
            if (n2 != -1) {
                byte[] byArray = new byte[n2];
                InputStreamUtil.readFully(inputStream, byArray, 0, n2);
                return byArray;
            }
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (SecurityException securityException) {
            throw this.handleException(securityException, string);
        }
    }

    private Certificate[] getSigners(String string, JarEntry jarEntry) throws IOException {
        try {
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                Object object;
                if (!(certificateArray[i] instanceof X509Certificate)) {
                    object = MessageService.getTextMessage("C001", string, this.getJarName());
                    throw new SecurityException((String)object);
                }
                object = (X509Certificate)certificateArray[i];
                ((X509Certificate)object).checkValidity();
            }
            return certificateArray;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw this.handleException(generalSecurityException, string);
        }
    }

    private SecurityException handleException(Exception exception, String string) {
        String string2 = MessageService.getTextMessage("C002", string, this.getJarName(), exception.getLocalizedMessage());
        return new SecurityException(string2);
    }

    public String toString() {
        return this.getJarName() + ":" + super.toString();
    }
}

