/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.util.PayloadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="hg", aliases={"hsync-generator"}, description={"Generate writes and hsync traffic on one or multiple files."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HsyncGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HsyncGenerator.class);
    @CommandLine.ParentCommand
    private Freon freon;
    @CommandLine.Option(names={"--path"}, description={"Hadoop FS file system path. Use full path."}, defaultValue="o3fs://bucket1.vol1")
    private String rootPath;
    @CommandLine.Option(names={"--bytes-per-write"}, description={"Size of each write"}, defaultValue="8")
    private int writeSize;
    @CommandLine.Option(names={"--writes-per-transaction"}, description={"Size of each write"}, defaultValue="32")
    private int writesPerTransaction;
    private Timer timer;
    private OzoneConfiguration configuration;
    private FSDataOutputStream outputStream;
    private byte[] data;
    private final BlockingQueue<Integer> writtenTransactions = new ArrayBlockingQueue<Integer>(10000);
    private final AtomicInteger lastSyncedTransaction = new AtomicInteger();

    public HsyncGenerator() {
    }

    @VisibleForTesting
    HsyncGenerator(OzoneConfiguration ozoneConfiguration) {
        this.configuration = ozoneConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        if (this.configuration == null) {
            this.configuration = this.freon.getOzoneConf();
        }
        URI uri = URI.create(this.rootPath);
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)this.configuration);
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(0L));
        fileSystem.mkdirs(file.getParent());
        this.outputStream = fileSystem.create(file);
        LOG.info("Created file for testing: {}", (Object)file);
        this.timer = this.getMetrics().timer("hsync-generator");
        this.data = PayloadUtils.generatePayload((int)this.writeSize);
        this.startTransactionWriter();
        try {
            this.runTests(this::sendHsync);
        }
        finally {
            this.outputStream.close();
            fileSystem.close();
        }
        return null;
    }

    private void startTransactionWriter() {
        Thread transactionWriter = new Thread(this::generateTransactions);
        transactionWriter.setDaemon(true);
        transactionWriter.start();
    }

    private void generateTransactions() {
        int transaction = 0;
        while (true) {
            for (int i = 0; i < this.writesPerTransaction; ++i) {
                try {
                    if (this.writeSize > 1) {
                        this.outputStream.write(this.data);
                        continue;
                    }
                    this.outputStream.write(i);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.writtenTransactions.put(transaction++);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void sendHsync(long counter) throws Exception {
        this.timer.time(() -> {
            int lastSynced;
            int transaction;
            while ((transaction = this.writtenTransactions.take().intValue()) <= (lastSynced = this.lastSyncedTransaction.get())) {
            }
            this.outputStream.hsync();
            this.lastSyncedTransaction.compareAndSet(lastSynced, transaction);
            return null;
        });
    }
}

