/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.LoggerSource;
import org.apache.hadoop.ozone.insight.MetricDisplay;
import org.apache.hadoop.ozone.insight.MetricGroupDisplay;

public abstract class BaseInsightPoint
implements InsightPoint {
    @Override
    public List<MetricGroupDisplay> getMetrics(Map<String, String> filters) {
        return new ArrayList<MetricGroupDisplay>();
    }

    @Override
    public List<Class> getConfigurationClasses() {
        return new ArrayList<Class>();
    }

    @Override
    public List<LoggerSource> getRelatedLoggers(boolean verbose, Map<String, String> filters) {
        ArrayList<LoggerSource> loggers = new ArrayList<LoggerSource>();
        return loggers;
    }

    public ScmClient createScmClient(OzoneConfiguration ozoneConf) throws IOException {
        if (!HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)ozoneConf, (String[])new String[]{"ozone.scm.client.address"}).isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address should be set in ozone-site.xml");
        }
        return new ContainerOperationClient(ozoneConf);
    }

    public LoggerSource.Level defaultLevel(boolean verbose) {
        return verbose ? LoggerSource.Level.TRACE : LoggerSource.Level.DEBUG;
    }

    public void addProtocolMessageMetrics(List<MetricGroupDisplay> metrics, String prefix, Component.Type type, Object[] types) {
        this.addProtocolMessageMetrics(metrics, prefix, new Component(type), types);
    }

    public void addProtocolMessageMetrics(List<MetricGroupDisplay> metrics, String prefix, Component component, Object[] types) {
        MetricGroupDisplay messageTypeCounters = new MetricGroupDisplay(component, "Message type counters");
        for (Object type : types) {
            String typeName = type.toString();
            HashMap<String, String> typeFilter = new HashMap<String, String>();
            typeFilter.put("type", typeName);
            MetricDisplay metricDisplay = new MetricDisplay("Number of " + typeName + " calls", prefix + "_counter", typeFilter);
            messageTypeCounters.addMetrics(metricDisplay);
        }
        metrics.add(messageTypeCounters);
    }

    public void addRpcMetrics(List<MetricGroupDisplay> metrics, Component.Type component, Map<String, String> filter) {
        MetricGroupDisplay connection = new MetricGroupDisplay(component, "RPC connections");
        connection.addMetrics(new MetricDisplay("Open connections", "rpc_num_open_connections", filter));
        connection.addMetrics(new MetricDisplay("Dropped connections", "rpc_num_dropped_connections", filter));
        connection.addMetrics(new MetricDisplay("Received bytes", "rpc_received_bytes", filter));
        connection.addMetrics(new MetricDisplay("Sent bytes", "rpc_sent_bytes", filter));
        metrics.add(connection);
        MetricGroupDisplay queue = new MetricGroupDisplay(component, "RPC queue");
        queue.addMetrics(new MetricDisplay("RPC average queue time", "rpc_rpc_queue_time_avg_time", filter));
        queue.addMetrics(new MetricDisplay("RPC call queue length", "rpc_call_queue_length", filter));
        metrics.add(queue);
        MetricGroupDisplay performance = new MetricGroupDisplay(component, "RPC performance");
        performance.addMetrics(new MetricDisplay("RPC processing time average", "rpc_rpc_processing_time_avg_time", filter));
        performance.addMetrics(new MetricDisplay("Number of slow calls", "rpc_rpc_slow_calls", filter));
        metrics.add(performance);
    }

    @Override
    public boolean filterLog(Map<String, String> filters, String logLine) {
        if (filters == null) {
            return true;
        }
        boolean result = true;
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            if (logLine.matches(String.format(".*\\[%s=%s\\].*", entry.getKey(), entry.getValue()))) continue;
            return false;
        }
        return true;
    }
}

