/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramDataPointStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogram;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import java.io.IOException;
import java.util.Collection;

final class ExponentialHistogramStatelessMarshaler
implements StatelessMarshaler<ExponentialHistogramData> {
    static final ExponentialHistogramStatelessMarshaler INSTANCE = new ExponentialHistogramStatelessMarshaler();
    private static final MarshalerContext.Key DATA_POINT_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key DATA_POINT_WRITER_KEY = MarshalerContext.key();

    private ExponentialHistogramStatelessMarshaler() {
    }

    public void writeTo(Serializer output, ExponentialHistogramData histogram, MarshalerContext context) throws IOException {
        output.serializeRepeatedMessageWithContext(ExponentialHistogram.DATA_POINTS, histogram.getPoints(), (StatelessMarshaler)ExponentialHistogramDataPointStatelessMarshaler.INSTANCE, context, DATA_POINT_WRITER_KEY);
        output.serializeEnum(ExponentialHistogram.AGGREGATION_TEMPORALITY, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    public int getBinarySerializedSize(ExponentialHistogramData histogram, MarshalerContext context) {
        int size = 0;
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)ExponentialHistogram.DATA_POINTS, (Collection)histogram.getPoints(), (StatelessMarshaler)ExponentialHistogramDataPointStatelessMarshaler.INSTANCE, (MarshalerContext)context, (MarshalerContext.Key)DATA_POINT_SIZE_CALCULATOR_KEY);
        return size += MarshalerUtil.sizeEnum((ProtoFieldInfo)ExponentialHistogram.AGGREGATION_TEMPORALITY, (ProtoEnumInfo)MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }
}

