/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.recon.schema;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ozone.recon.schema.ReconSchemaDefinition;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

@Singleton
public class StatsSchemaDefinition
implements ReconSchemaDefinition {
    public static final String GLOBAL_STATS_TABLE_NAME = "GLOBAL_STATS";
    private DSLContext dslContext;
    private final DataSource dataSource;

    @Inject
    StatsSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.dslContext = DSL.using((Connection)conn);
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, GLOBAL_STATS_TABLE_NAME)) {
            this.createGlobalStatsTable();
        }
    }

    private void createGlobalStatsTable() {
        this.dslContext.createTableIfNotExists(GLOBAL_STATS_TABLE_NAME).column("key", SQLDataType.VARCHAR((int)255).nullable(false)).column("value", SQLDataType.BIGINT).column("last_updated_timestamp", SQLDataType.TIMESTAMP).constraint((Constraint)DSL.constraint((String)"pk_key").primaryKey(new String[]{"key"})).execute();
    }
}

