/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.recon.schema;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ozone.recon.schema.ReconSchemaDefinition;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaVersionTableDefinition
implements ReconSchemaDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaVersionTableDefinition.class);
    public static final String SCHEMA_VERSION_TABLE_NAME = "RECON_SCHEMA_VERSION";
    private final DataSource dataSource;
    private int latestSLV;

    @Inject
    public SchemaVersionTableDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initializeSchema() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();){
            DSLContext localDslContext = DSL.using((Connection)conn);
            if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, SCHEMA_VERSION_TABLE_NAME)) {
                boolean isFreshInstall = SqlDbUtils.listAllTables(conn).isEmpty();
                this.createSchemaVersionTable(localDslContext);
                if (isFreshInstall) {
                    this.insertInitialSLV(localDslContext, this.latestSLV);
                }
            }
        }
    }

    private void createSchemaVersionTable(DSLContext dslContext) {
        dslContext.createTableIfNotExists(SCHEMA_VERSION_TABLE_NAME).column("version_number", SQLDataType.INTEGER.nullable(false)).column("applied_on", SQLDataType.TIMESTAMP.defaultValue(DSL.currentTimestamp())).execute();
    }

    private void insertInitialSLV(DSLContext dslContext, int slv) {
        dslContext.insertInto(DSL.table((String)SCHEMA_VERSION_TABLE_NAME)).columns(DSL.field((Name)DSL.name((String)"version_number")), DSL.field((Name)DSL.name((String)"applied_on"))).values((Object)slv, (Object)DSL.currentTimestamp()).execute();
        LOG.info("Inserted initial SLV '{}' into SchemaVersion table.", (Object)slv);
    }

    public void setLatestSLV(int slv) {
        this.latestSLV = slv;
    }
}

