/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;

public final class UUIDv7 {
    private static final ThreadLocal<SecureRandom> GENERATOR = ThreadLocal.withInitial(SecureRandom::new);

    private UUIDv7() {
    }

    public static UUID randomUUID() {
        byte[] value = UUIDv7.randomBytes();
        ByteBuffer buf = ByteBuffer.wrap(value);
        long high = buf.getLong();
        long low = buf.getLong();
        return new UUID(high, low);
    }

    public static byte[] randomBytes() {
        byte[] value = new byte[16];
        GENERATOR.get().nextBytes(value);
        ByteBuffer timestamp = ByteBuffer.allocate(8);
        timestamp.putLong(System.currentTimeMillis());
        System.arraycopy(timestamp.array(), 2, value, 0, 6);
        value[6] = (byte)(value[6] & 0xF | 0x70);
        value[8] = (byte)(value[8] & 0x3F | 0x80);
        return value;
    }
}

