/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Security;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneNetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneNetUtils.class);

    private OzoneNetUtils() {
    }

    public static void disableJvmNetworkAddressCacheIfRequired(OzoneConfiguration conf) {
        boolean networkAddressCacheEnabled = conf.getBoolean("ozone.network.jvm.address.cache.enabled", true);
        if (!networkAddressCacheEnabled) {
            LOG.info("Disabling JVM DNS cache");
            Security.setProperty("networkaddress.cache.ttl", "0");
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
    }

    public static boolean isAddressHostNameLocal(InetSocketAddress addr) {
        if (addr == null) {
            return false;
        }
        String hostNameWithoutDomain = OzoneNetUtils.getHostNameWithoutDomain(addr.getHostName());
        return NetUtils.getLocalHostname().equals(hostNameWithoutDomain);
    }

    public static InetSocketAddress getAddressWithHostNameLocal(InetSocketAddress addr) {
        String fqdn = addr.getHostName();
        String hostName = OzoneNetUtils.getHostNameWithoutDomain(fqdn);
        return NetUtils.createSocketAddr((String)hostName, (int)addr.getPort());
    }

    private static String getHostNameWithoutDomain(String fqdn) {
        return fqdn.split("\\.")[0];
    }

    public static boolean isAddressLocal(InetSocketAddress addr) {
        InetAddress inetAddress = addr.getAddress();
        return inetAddress != null && NetUtils.isLocalAddress((InetAddress)inetAddress);
    }

    public static boolean isUnresolved(boolean flexibleFqdnResolutionEnabled, InetSocketAddress addr) {
        return !flexibleFqdnResolutionEnabled && addr.isUnresolved() || flexibleFqdnResolutionEnabled && !OzoneNetUtils.isAddressHostNameLocal(addr);
    }

    public static boolean isAddressLocal(boolean flexibleFqdnResolutionEnabled, InetSocketAddress addr) {
        return !flexibleFqdnResolutionEnabled && !addr.isUnresolved() && OzoneNetUtils.isAddressLocal(addr) || flexibleFqdnResolutionEnabled && OzoneNetUtils.isAddressHostNameLocal(addr);
    }
}

