/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.grpc.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(about="GRPC Metrics", context="ozone")
public class GrpcMetrics
implements MetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcMetrics.class);
    private static final MetricsInfo LATEST_REQUEST_TYPE = Interns.info((String)"LatestRequestType", (String)"Latest type of request for which metrics were captured");
    private static final String SOURCE_NAME = GrpcMetrics.class.getSimpleName();
    private final MetricsRegistry registry = new MetricsRegistry("grpc");
    private final boolean grpcQuantileEnable;
    private String requestType = "NoRequest";
    @Metric(value={"Number of sent bytes"})
    private MutableCounterLong sentBytes;
    @Metric(value={"Number of received bytes"})
    private MutableCounterLong receivedBytes;
    @Metric(value={"Number of unknown messages sent"})
    private MutableCounterLong unknownMessagesSent;
    @Metric(value={"Number of unknown messages received"})
    private MutableCounterLong unknownMessagesReceived;
    @Metric(value={"Queue time"})
    private MutableRate grpcQueueTime;
    private MutableQuantiles[] grpcQueueTimeMillisQuantiles;
    @Metric(value={"Processsing time"})
    private MutableRate grpcProcessingTime;
    private MutableQuantiles[] grpcProcessingTimeMillisQuantiles;
    @Metric(value={"Number of active clients connected"})
    private MutableCounterLong numOpenClientConnections;

    public GrpcMetrics(Configuration conf) {
        int[] intervals = conf.getInts("ozone.grpc.metrics.percentiles.intervals");
        boolean bl = this.grpcQuantileEnable = intervals.length > 0;
        if (this.grpcQuantileEnable) {
            this.grpcQueueTimeMillisQuantiles = new MutableQuantiles[intervals.length];
            this.grpcProcessingTimeMillisQuantiles = new MutableQuantiles[intervals.length];
            for (int i = 0; i < intervals.length; ++i) {
                int interval = intervals[i];
                this.grpcQueueTimeMillisQuantiles[i] = this.registry.newQuantiles("grpcQueueTime" + interval + "s", "grpc queue time in millisecond", "ops", "latency", interval);
                this.grpcProcessingTimeMillisQuantiles[i] = this.registry.newQuantiles("grpcProcessingTime" + interval + "s", "grpc processing time in millisecond", "ops", "latency", interval);
            }
        }
        LOG.debug("Initialized " + this.registry);
    }

    public static synchronized GrpcMetrics create(Configuration conf) {
        GrpcMetrics metrics = new GrpcMetrics(conf);
        return (GrpcMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME, "Metrics for using gRPC", (Object)metrics);
    }

    public void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME);
        MetricUtil.stop(this.grpcProcessingTimeMillisQuantiles);
        MetricUtil.stop(this.grpcQueueTimeMillisQuantiles);
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        recordBuilder.tag(LATEST_REQUEST_TYPE, this.requestType);
    }

    public void incrSentBytes(long byteCount) {
        this.sentBytes.incr(byteCount);
    }

    public void incrReceivedBytes(long byteCount) {
        this.receivedBytes.incr(byteCount);
    }

    public void incrUnknownMessagesSent() {
        this.unknownMessagesSent.incr();
    }

    public void incrUnknownMessagesReceived() {
        this.unknownMessagesReceived.incr();
    }

    public void addGrpcQueueTime(int queueTime) {
        this.grpcQueueTime.add((long)queueTime);
        if (this.grpcQuantileEnable) {
            for (MutableQuantiles q : this.grpcQueueTimeMillisQuantiles) {
                if (q == null) continue;
                q.add((long)queueTime);
            }
        }
    }

    public void addGrpcProcessingTime(int processingTime) {
        this.grpcProcessingTime.add((long)processingTime);
        if (this.grpcQuantileEnable) {
            for (MutableQuantiles q : this.grpcProcessingTimeMillisQuantiles) {
                if (q == null) continue;
                q.add((long)processingTime);
            }
        }
    }

    public void inrcNumOpenClientConnections() {
        this.numOpenClientConnections.incr();
    }

    public void decrNumOpenClientConnections() {
        this.numOpenClientConnections.incr(-1L);
    }

    public long getSentBytes() {
        return this.sentBytes.value();
    }

    public long getReceivedBytes() {
        return this.receivedBytes.value();
    }

    public long getUnknownMessagesSent() {
        return this.unknownMessagesSent.value();
    }

    public long getUnknownMessagesReceived() {
        return this.unknownMessagesReceived.value();
    }

    MutableRate getGrpcQueueTime() {
        return this.grpcQueueTime;
    }

    MutableRate getGrpcProcessingTime() {
        return this.grpcProcessingTime;
    }

    public long getNumActiveClientConnections() {
        return this.numOpenClientConnections.value();
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestType() {
        return this.requestType;
    }
}

