/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.metrics.S3GatewayMetrics;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObjectEndpointStreaming {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectEndpointStreaming.class);
    private static final S3GatewayMetrics METRICS = S3GatewayMetrics.getMetrics();

    private ObjectEndpointStreaming() {
    }

    public static Pair<String, Long> put(OzoneBucket bucket, String keyPath, long length, ReplicationConfig replicationConfig, int chunkSize, Map<String, String> keyMetadata, Map<String, String> tags, DigestInputStream body, AuditLogger.PerformanceStringBuilder perf) throws IOException, OS3Exception {
        try {
            return ObjectEndpointStreaming.putKeyWithStream(bucket, keyPath, length, chunkSize, replicationConfig, keyMetadata, tags, body, perf);
        }
        catch (IOException ex) {
            LOG.error("Exception occurred in PutObject", (Throwable)ex);
            if (ex instanceof OMException) {
                if (((OMException)((Object)ex)).getResult() == OMException.ResultCodes.NOT_A_FILE) {
                    OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, keyPath);
                    os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the PutObject/MPU PartUpload operation: ozone.om.enable.filesystem.paths is enabled Keys are considered as Unix Paths. Path has Violated FS Semantics which caused put operation to fail.");
                    throw os3Exception;
                }
                if (((OMException)((Object)ex)).getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                    throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath);
                }
            }
            throw ex;
        }
    }

    public static Pair<String, Long> putKeyWithStream(OzoneBucket bucket, String keyPath, long length, int bufferSize, ReplicationConfig replicationConfig, Map<String, String> keyMetadata, Map<String, String> tags, DigestInputStream body, AuditLogger.PerformanceStringBuilder perf) throws IOException {
        String eTag;
        long writeLen;
        long startNanos = Time.monotonicNowNanos();
        try (OzoneDataStreamOutput streamOutput = bucket.createStreamKey(keyPath, length, replicationConfig, keyMetadata, tags);){
            long metadataLatencyNs = METRICS.updatePutKeyMetadataStats(startNanos);
            writeLen = ObjectEndpointStreaming.writeToStreamOutput(streamOutput, body, bufferSize, length);
            eTag = DatatypeConverter.printHexBinary((byte[])body.getMessageDigest().digest()).toLowerCase();
            perf.appendMetaLatencyNanos(metadataLatencyNs);
            streamOutput.getMetadata().put("ETag", eTag);
        }
        return Pair.of((Object)eTag, (Object)writeLen);
    }

    public static long copyKeyWithStream(OzoneBucket bucket, String keyPath, long length, int bufferSize, ReplicationConfig replicationConfig, Map<String, String> keyMetadata, DigestInputStream body, AuditLogger.PerformanceStringBuilder perf, long startNanos, Map<String, String> tags) throws IOException {
        long writeLen;
        try (OzoneDataStreamOutput streamOutput = bucket.createStreamKey(keyPath, length, replicationConfig, keyMetadata, tags);){
            long metadataLatencyNs = METRICS.updateCopyKeyMetadataStats(startNanos);
            writeLen = ObjectEndpointStreaming.writeToStreamOutput(streamOutput, body, bufferSize, length);
            String eTag = DatatypeConverter.printHexBinary((byte[])body.getMessageDigest().digest()).toLowerCase();
            perf.appendMetaLatencyNanos(metadataLatencyNs);
            streamOutput.getMetadata().put("ETag", eTag);
        }
        return writeLen;
    }

    private static long writeToStreamOutput(OzoneDataStreamOutput streamOutput, InputStream body, int bufferSize, long length) throws IOException {
        int toRead;
        long n;
        int readLength;
        byte[] buffer = new byte[bufferSize];
        for (n = 0L; n < length && (readLength = body.read(buffer, 0, toRead = Math.toIntExact(Math.min((long)bufferSize, length - n)))) != -1; n += (long)readLength) {
            streamOutput.write(ByteBuffer.wrap(buffer, 0, readLength));
        }
        return n;
    }

    public static Response createMultipartKey(OzoneBucket ozoneBucket, String key, long length, int partNumber, String uploadID, int chunkSize, DigestInputStream body, AuditLogger.PerformanceStringBuilder perf) throws IOException, OS3Exception {
        String eTag;
        long startNanos = Time.monotonicNowNanos();
        try (OzoneDataStreamOutput streamOutput = ozoneBucket.createMultipartStreamKey(key, length, partNumber, uploadID);){
            long metadataLatencyNs = METRICS.updatePutKeyMetadataStats(startNanos);
            long putLength = ObjectEndpointStreaming.writeToStreamOutput(streamOutput, body, chunkSize, length);
            eTag = DatatypeConverter.printHexBinary((byte[])body.getMessageDigest().digest()).toLowerCase();
            streamOutput.getMetadata().put("ETag", eTag);
            METRICS.incPutKeySuccessLength(putLength);
            perf.appendMetaLatencyNanos(metadataLatencyNs);
            perf.appendSizeBytes(putLength);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, ozoneBucket.getName() + "/" + key);
            }
            throw ex;
        }
        return Response.ok().header("ETag", (Object)eTag).build();
    }
}

