/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OmUpdateEventValidator;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBUpdatesHandler
extends WriteBatch.Handler {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBUpdatesHandler.class);
    private Map<Integer, String> tablesNames;
    private OMMetadataManager omMetadataManager;
    private List<OMDBUpdateEvent> omdbUpdateEvents = new ArrayList<OMDBUpdateEvent>();
    private Map<String, Map<Object, OMDBUpdateEvent>> omdbLatestUpdateEvents = new HashMap<String, Map<Object, OMDBUpdateEvent>>();
    private final OMDBDefinition omdbDefinition = OMDBDefinition.get();
    private final OmUpdateEventValidator omUpdateEventValidator = new OmUpdateEventValidator(this.omdbDefinition);
    private long batchSequenceNumber;

    public OMDBUpdatesHandler(OMMetadataManager metadataManager) {
        this.omMetadataManager = metadataManager;
        this.tablesNames = metadataManager.getStore().getTableNames();
    }

    public void setLatestSequenceNumber(long sequenceNumber) {
        this.batchSequenceNumber = sequenceNumber;
    }

    public long getLatestSequenceNumber() {
        return this.batchSequenceNumber;
    }

    public void put(int cfIndex, byte[] keyBytes, byte[] valueBytes) {
        try {
            this.processEvent(cfIndex, keyBytes, valueBytes, OMDBUpdateEvent.OMDBUpdateAction.PUT);
        }
        catch (IOException ioEx) {
            LOG.error("Exception when reading key : ", (Throwable)ioEx);
        }
    }

    public void delete(int cfIndex, byte[] keyBytes) {
        try {
            this.processEvent(cfIndex, keyBytes, null, OMDBUpdateEvent.OMDBUpdateAction.DELETE);
        }
        catch (IOException ioEx) {
            LOG.error("Exception when reading key : ", (Throwable)ioEx);
        }
    }

    private void processEvent(int cfIndex, byte[] keyBytes, byte[] valueBytes, OMDBUpdateEvent.OMDBUpdateAction action) throws IOException {
        String tableName = this.tablesNames.get(cfIndex);
        DBColumnFamilyDefinition cf = this.omdbDefinition.getColumnFamily(tableName);
        if (cf != null) {
            OMDBUpdateEvent.OMUpdateEventBuilder<Object, Object> builder = new OMDBUpdateEvent.OMUpdateEventBuilder<Object, Object>();
            builder.setTable(tableName);
            builder.setAction(action);
            Object key = cf.getKeyCodec().fromPersistedFormat(keyBytes);
            builder.setKey(key);
            this.omdbLatestUpdateEvents.putIfAbsent(tableName, new HashMap());
            Map<Object, OMDBUpdateEvent> tableEventsMap = this.omdbLatestUpdateEvents.get(tableName);
            Table table = this.omMetadataManager.getTable(tableName);
            OMDBUpdateEvent latestEvent = tableEventsMap.get(key);
            Object oldValue = latestEvent != null ? latestEvent.getValue() : table.getSkipCache(key);
            if (action.equals((Object)OMDBUpdateEvent.OMDBUpdateAction.PUT)) {
                Object value = cf.getValueCodec().fromPersistedFormat(valueBytes);
                if (!this.omUpdateEventValidator.isValidEvent(tableName, value, key, action)) {
                    return;
                }
                builder.setValue(value);
                if (oldValue != null) {
                    if (!this.omUpdateEventValidator.isValidEvent(tableName, oldValue, key, action)) {
                        return;
                    }
                    builder.setOldValue(oldValue);
                    if (latestEvent == null || latestEvent.getAction() != OMDBUpdateEvent.OMDBUpdateAction.DELETE) {
                        builder.setAction(OMDBUpdateEvent.OMDBUpdateAction.UPDATE);
                    }
                }
            } else if (action.equals((Object)OMDBUpdateEvent.OMDBUpdateAction.DELETE)) {
                if (null == oldValue) {
                    String keyStr;
                    String string = keyStr = key instanceof String ? key.toString() : "";
                    if (keyStr.isEmpty()) {
                        LOG.warn("Only DTOKEN_TABLE table uses OzoneTokenIdentifier as key instead of String. Event on any other table in this condition may need to be investigated. This DELETE event is on {} table which is not useful for Recon to capture.", (Object)tableName);
                    }
                    LOG.debug("Old Value of Key: {} in table: {} should not be null for DELETE event ", (Object)keyStr, (Object)tableName);
                    return;
                }
                if (!this.omUpdateEventValidator.isValidEvent(tableName, oldValue, key, action)) {
                    return;
                }
                builder.setValue(oldValue);
            }
            OMDBUpdateEvent event = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Generated OM update Event for table : %s, action = %s", new Object[]{tableName, action}));
            }
            this.omdbUpdateEvents.add(event);
            tableEventsMap.put(key, event);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn(String.format("KeyType or ValueType could not be determined for table %s. Ignoring the event.", tableName));
        }
    }

    public void put(byte[] bytes, byte[] bytes1) {
    }

    public void merge(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void merge(byte[] bytes, byte[] bytes1) {
    }

    public void delete(byte[] bytes) {
    }

    public void singleDelete(int i, byte[] bytes) throws RocksDBException {
    }

    public void singleDelete(byte[] bytes) {
    }

    public void deleteRange(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void deleteRange(byte[] bytes, byte[] bytes1) {
    }

    public void logData(byte[] bytes) {
    }

    public void putBlobIndex(int i, byte[] bytes, byte[] bytes1) throws RocksDBException {
    }

    public void markBeginPrepare() throws RocksDBException {
    }

    public void markEndPrepare(byte[] bytes) throws RocksDBException {
    }

    public void markNoop(boolean b) throws RocksDBException {
    }

    public void markRollback(byte[] bytes) throws RocksDBException {
    }

    public void markCommit(byte[] bytes) throws RocksDBException {
    }

    public void markCommitWithTimestamp(byte[] xid, byte[] ts) throws RocksDBException {
    }

    public List<OMDBUpdateEvent> getEvents() {
        return this.omdbUpdateEvents;
    }
}

