/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithFSO;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithLegacy;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithOBS;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTask.class);
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager reconOMMetadataManager;
    private final NSSummaryTaskWithFSO nsSummaryTaskWithFSO;
    private final NSSummaryTaskWithLegacy nsSummaryTaskWithLegacy;
    private final NSSummaryTaskWithOBS nsSummaryTaskWithOBS;

    @Inject
    public NSSummaryTask(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
        long nsSummaryFlushToDBMaxThreshold = ozoneConfiguration.getLong("ozone.recon.nssummary.flush.db.max.threshold", 150000L);
        this.nsSummaryTaskWithFSO = new NSSummaryTaskWithFSO(reconNamespaceSummaryManager, reconOMMetadataManager, nsSummaryFlushToDBMaxThreshold);
        this.nsSummaryTaskWithLegacy = new NSSummaryTaskWithLegacy(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration, nsSummaryFlushToDBMaxThreshold);
        this.nsSummaryTaskWithOBS = new NSSummaryTaskWithOBS(reconNamespaceSummaryManager, reconOMMetadataManager, nsSummaryFlushToDBMaxThreshold);
    }

    @Override
    public String getTaskName() {
        return "NSSummaryTask";
    }

    @Override
    public ReconOmTask.TaskResult process(OMUpdateEventBatch events, Map<String, Integer> subTaskSeekPosMap) {
        boolean anyFailure = false;
        HashMap<String, Integer> updatedSeekPositions = new HashMap<String, Integer>();
        Integer bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.FSO.name(), 0);
        Pair<Integer, Boolean> bucketResult = this.nsSummaryTaskWithFSO.processWithFSO(events, bucketSeek);
        updatedSeekPositions.put(BucketType.FSO.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithFSO failed.");
            anyFailure = true;
        }
        bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.LEGACY.name(), 0);
        bucketResult = this.nsSummaryTaskWithLegacy.processWithLegacy(events, bucketSeek);
        updatedSeekPositions.put(BucketType.LEGACY.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithLegacy failed.");
            anyFailure = true;
        }
        bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.OBS.name(), 0);
        bucketResult = this.nsSummaryTaskWithOBS.processWithOBS(events, bucketSeek);
        updatedSeekPositions.put(BucketType.OBS.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithOBS failed.");
            anyFailure = true;
        }
        return new ReconOmTask.TaskResult.Builder().setTaskName(this.getTaskName()).setSubTaskSeekPositions(updatedSeekPositions).setTaskSuccess(!anyFailure).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager) {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        long startTime = System.nanoTime();
        try {
            this.reconNamespaceSummaryManager.clearNSSummaryTable();
        }
        catch (IOException ioEx) {
            LOG.error("Unable to clear NSSummary table in Recon DB. ", (Throwable)ioEx);
            return this.buildTaskResult(false);
        }
        tasks.add(() -> this.nsSummaryTaskWithFSO.reprocessWithFSO(omMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithLegacy.reprocessWithLegacy(this.reconOMMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithOBS.reprocessWithOBS(this.reconOMMetadataManager));
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Recon-NSSummaryTask-%d").build();
        ExecutorService executorService = Executors.newFixedThreadPool(2, threadFactory);
        try {
            List results = executorService.invokeAll(tasks);
            for (Future result : results) {
                if (!((Boolean)result.get()).equals(false)) continue;
                ReconOmTask.TaskResult taskResult = this.buildTaskResult(false);
                return taskResult;
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.error("Error while reprocessing NSSummary table in Recon DB.", (Throwable)ex);
            ReconOmTask.TaskResult taskResult = this.buildTaskResult(false);
            return taskResult;
        }
        finally {
            executorService.shutdown();
            long endTime = System.nanoTime();
            long durationInMillis = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
            LOG.debug("Task execution time: {} milliseconds", (Object)durationInMillis);
        }
        return this.buildTaskResult(true);
    }

    public static enum BucketType {
        FSO("File System Optimized Bucket"),
        OBS("Object Store Bucket"),
        LEGACY("Legacy Bucket");

        private final String description;

        private BucketType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

