/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
@Metrics(about="Recon ContainerHealthTask Metrics", context="ozone")
public final class ContainerHealthMetrics {
    private static final String SOURCE_NAME = ContainerHealthMetrics.class.getSimpleName();
    @Metric(about="Number of missing containers detected in Recon.")
    private MutableGaugeLong missingContainerCount;
    @Metric(about="Number of under replicated containers detected in Recon.")
    private MutableGaugeLong underReplicatedContainerCount;
    @Metric(about="Number of replica mismatch containers detected in Recon.")
    private MutableGaugeLong replicaMisMatchContainerCount;

    private ContainerHealthMetrics() {
    }

    public static ContainerHealthMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ContainerHealthMetrics)ms.register(SOURCE_NAME, "Recon Container Health Task Metrics", (Object)new ContainerHealthMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void setMissingContainerCount(long missingContainerCount) {
        this.missingContainerCount.set(missingContainerCount);
    }

    public void setUnderReplicatedContainerCount(long underReplicatedContainerCount) {
        this.underReplicatedContainerCount.set(underReplicatedContainerCount);
    }

    public void setReplicaMisMatchContainerCount(long replicaMisMatchContainerCount) {
        this.replicaMisMatchContainerCount.set(replicaMisMatchContainerCount);
    }

    public long getMissingContainerCount() {
        return this.missingContainerCount.value();
    }

    public long getUnderReplicatedContainerCount() {
        return this.underReplicatedContainerCount.value();
    }

    public long getReplicaMisMatchContainerCount() {
        return this.replicaMisMatchContainerCount.value();
    }
}

